/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.JavaAnnotation;
import com.github.tadukoo.java.JavaClass;
import com.github.tadukoo.java.JavaClassBuilder;
import com.github.tadukoo.java.JavaField;
import com.github.tadukoo.java.JavaMethod;
import com.github.tadukoo.java.Javadoc;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.uneditable.UneditableJavaAnnotation;
import com.github.tadukoo.java.uneditable.UneditableJavaField;
import com.github.tadukoo.java.uneditable.UneditableJavaMethod;
import com.github.tadukoo.java.uneditable.UneditableJavadoc;
import com.github.tadukoo.util.ListUtil;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JavaClassTest {
    private String packageName;
    private String className;
    private JavaClass clazz;

    @BeforeEach
    public void setup() {
        this.packageName = "some.package";
        this.className = "AClassName";
        this.clazz = new TestJavaClassBuilder(false).packageName(this.packageName).className(this.className).build();
    }

    @Test
    public void testIsEditable() {
        Assertions.assertFalse((boolean)this.clazz.isEditable());
    }

    @Test
    public void testIsEditableTrue() {
        this.clazz = new TestJavaClassBuilder(true).packageName(this.packageName).className(this.className).build();
        Assertions.assertTrue((boolean)this.clazz.isEditable());
    }

    @Test
    public void testToString() {
        String javaString = "package some.package;\n\npublic class AClassName{\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithSuperClassName() {
        this.clazz = new TestJavaClassBuilder(false).packageName(this.packageName).className(this.className).superClassName("AnotherClassName").build();
        String javaString = "package some.package;\n\npublic class AClassName extends AnotherClassName{\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithJavadoc() {
        this.clazz = new TestJavaClassBuilder(false).packageName(this.packageName).className(this.className).javadoc(UneditableJavadoc.builder().build()).build();
        String javaString = "package some.package;\n\n/**\n */\npublic class AClassName{\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithAnnotations() {
        JavaAnnotation test = UneditableJavaAnnotation.builder().name("Test").build();
        JavaAnnotation derp = UneditableJavaAnnotation.builder().name("Derp").build();
        List annotations = ListUtil.createList((Object[])new JavaAnnotation[]{test, derp});
        this.clazz = new TestJavaClassBuilder(false).packageName(this.packageName).className(this.className).annotations(annotations).build();
        String javaString = "package some.package;\n\n@Test\n@Derp\npublic class AClassName{\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithImports() {
        this.clazz = new TestJavaClassBuilder(false).packageName(this.packageName).className(this.className).imports(ListUtil.createList((Object[])new String[]{"com.example.*", null, "com.github.tadukoo.*"})).build();
        String javaString = "package some.package;\n\nimport com.example.*;\n\nimport com.github.tadukoo.*;\n\npublic class AClassName{\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithStaticImports() {
        this.clazz = new TestJavaClassBuilder(false).packageName(this.packageName).className(this.className).staticImports(ListUtil.createList((Object[])new String[]{"com.example.Test", null, "com.github.tadukoo.test.*"})).build();
        String javaString = "package some.package;\n\nimport static com.example.Test;\n\nimport static com.github.tadukoo.test.*;\n\npublic class AClassName{\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithInnerClasses() {
        this.clazz = new TestJavaClassBuilder(false).packageName(this.packageName).className(this.className).innerClass(new TestJavaClassBuilder(false).innerClass().className("BClassName").build()).innerClass(new TestJavaClassBuilder(false).innerClass().className("CClassName").build()).build();
        String javaString = "package some.package;\n\npublic class AClassName{\n\t\n\tpublic class BClassName{\n\t\t\n\t}\n\t\n\tpublic class CClassName{\n\t\t\n\t}\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithFields() {
        this.clazz = new TestJavaClassBuilder(false).packageName(this.packageName).className(this.className).field(UneditableJavaField.builder().type("int").name("test").build()).field(UneditableJavaField.builder().type("String").name("derp").build()).build();
        String javaString = "package some.package;\n\npublic class AClassName{\n\t\n\tprivate int test;\n\tprivate String derp;\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithFieldsWithJavadocsOnFields() {
        this.clazz = new TestJavaClassBuilder(false).packageName(this.packageName).className(this.className).field(UneditableJavaField.builder().javadoc(UneditableJavadoc.builder().condensed().content("something").build()).type("int").name("test").build()).field(UneditableJavaField.builder().type("String").name("derp").build()).build();
        String javaString = "package some.package;\n\npublic class AClassName{\n\t\n\t/** something */\n\tprivate int test;\n\tprivate String derp;\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithMethods() {
        this.clazz = new TestJavaClassBuilder(false).packageName(this.packageName).className(this.className).method(UneditableJavaMethod.builder().returnType(this.className).build()).method(UneditableJavaMethod.builder().returnType("String").name("getSomething").parameter("int", "test").line("return doSomething();").build()).build();
        String javaString = "package some.package;\n\npublic class AClassName{\n\t\n\tpublic AClassName(){\n\t}\n\t\n\tpublic String getSomething(int test){\n\t\treturn doSomething();\n\t}\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithEverything() {
        this.clazz = new TestJavaClassBuilder(false).packageName(this.packageName).imports(ListUtil.createList((Object[])new String[]{"com.example.*", "", "com.github.tadukoo.*"})).staticImports(ListUtil.createList((Object[])new String[]{"com.example.Test", "", "com.github.tadukoo.test.*"})).javadoc(UneditableJavadoc.builder().build()).annotation(UneditableJavaAnnotation.builder().name("Test").build()).annotation(UneditableJavaAnnotation.builder().name("Derp").build()).className(this.className).superClassName("AnotherClassName").innerClass(new TestJavaClassBuilder(false).innerClass().className("BClassName").build()).innerClass(new TestJavaClassBuilder(false).innerClass().className("CClassName").build()).field(UneditableJavaField.builder().type("int").name("test").build()).field(UneditableJavaField.builder().type("String").name("derp").build()).method(UneditableJavaMethod.builder().returnType(this.className).build()).method(UneditableJavaMethod.builder().returnType("String").name("getSomething").parameter("int", "test").line("return doSomething();").build()).build();
        String javaString = "package some.package;\n\nimport com.example.*;\n\nimport com.github.tadukoo.*;\n\nimport static com.example.Test;\n\nimport static com.github.tadukoo.test.*;\n\n/**\n */\n@Test\n@Derp\npublic class AClassName extends AnotherClassName{\n\t\n\tpublic class BClassName{\n\t\t\n\t}\n\t\n\tpublic class CClassName{\n\t\t\n\t}\n\t\n\tprivate int test;\n\tprivate String derp;\n\t\n\tpublic AClassName(){\n\t}\n\t\n\tpublic String getSomething(int test){\n\t\treturn doSomething();\n\t}\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringInnerClass() {
        this.clazz = new TestJavaClassBuilder(false).innerClass().className(this.className).build();
        Assertions.assertEquals((Object)"public class AClassName{\n\t\n}\n", (Object)this.clazz.toString());
    }

    @Test
    public void testToStringStaticInnerClass() {
        this.clazz = new TestJavaClassBuilder(false).innerClass().isStatic().className(this.className).build();
        Assertions.assertEquals((Object)"public static class AClassName{\n\t\n}\n", (Object)this.clazz.toString());
    }

    @Test
    public void testToStringInnerClassWithEverything() {
        this.clazz = new TestJavaClassBuilder(false).innerClass().javadoc(UneditableJavadoc.builder().build()).annotation(UneditableJavaAnnotation.builder().name("Test").build()).annotation(UneditableJavaAnnotation.builder().name("Derp").build()).isStatic().className(this.className).superClassName("AnotherClassName").innerClass(new TestJavaClassBuilder(false).innerClass().className("BClassName").build()).innerClass(new TestJavaClassBuilder(false).innerClass().className("CClassName").build()).field(UneditableJavaField.builder().type("int").name("test").build()).field(UneditableJavaField.builder().type("String").name("derp").build()).method(UneditableJavaMethod.builder().returnType(this.className).build()).method(UneditableJavaMethod.builder().returnType("String").name("getSomething").parameter("int", "test").line("return doSomething();").build()).build();
        String javaString = "/**\n */\n@Test\n@Derp\npublic static class AClassName extends AnotherClassName{\n\t\n\tpublic class BClassName{\n\t\t\n\t}\n\t\n\tpublic class CClassName{\n\t\t\n\t}\n\t\n\tprivate int test;\n\tprivate String derp;\n\t\n\tpublic AClassName(){\n\t}\n\t\n\tpublic String getSomething(int test){\n\t\treturn doSomething();\n\t}\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testEquals() {
        this.clazz = new TestJavaClassBuilder(false).packageName(this.packageName).imports(ListUtil.createList((Object[])new String[]{"com.example.*", "", "com.github.tadukoo.*"})).staticImports(ListUtil.createList((Object[])new String[]{"com.example.Test", "", "com.github.tadukoo.test.*"})).javadoc(UneditableJavadoc.builder().build()).annotation(UneditableJavaAnnotation.builder().name("Test").build()).annotation(UneditableJavaAnnotation.builder().name("Derp").build()).className(this.className).superClassName("AnotherClassName").innerClass(new TestJavaClassBuilder(false).innerClass().className("BClassName").build()).innerClass(new TestJavaClassBuilder(false).innerClass().className("CClassName").build()).field(UneditableJavaField.builder().type("int").name("test").build()).field(UneditableJavaField.builder().type("String").name("derp").build()).method(UneditableJavaMethod.builder().returnType(this.className).build()).method(UneditableJavaMethod.builder().returnType("String").name("getSomething").parameter("int", "test").line("return doSomething();").build()).build();
        JavaClass otherClass = new TestJavaClassBuilder(false).packageName(this.packageName).imports(ListUtil.createList((Object[])new String[]{"com.example.*", "", "com.github.tadukoo.*"})).staticImports(ListUtil.createList((Object[])new String[]{"com.example.Test", "", "com.github.tadukoo.test.*"})).javadoc(UneditableJavadoc.builder().build()).annotation(UneditableJavaAnnotation.builder().name("Test").build()).annotation(UneditableJavaAnnotation.builder().name("Derp").build()).className(this.className).superClassName("AnotherClassName").innerClass(new TestJavaClassBuilder(false).innerClass().className("BClassName").build()).innerClass(new TestJavaClassBuilder(false).innerClass().className("CClassName").build()).field(UneditableJavaField.builder().type("int").name("test").build()).field(UneditableJavaField.builder().type("String").name("derp").build()).method(UneditableJavaMethod.builder().returnType(this.className).build()).method(UneditableJavaMethod.builder().returnType("String").name("getSomething").parameter("int", "test").line("return doSomething();").build()).build();
        Assertions.assertEquals((Object)this.clazz, (Object)otherClass);
    }

    @Test
    public void testEqualsNotEqual() {
        JavaClass otherClass = new TestJavaClassBuilder(false).packageName("some.package.different").className(this.className).build();
        Assertions.assertNotEquals((Object)this.clazz, (Object)otherClass);
    }

    @Test
    public void testEqualsNotSameType() {
        Assertions.assertNotEquals((Object)this.clazz, (Object)"testing");
    }

    private static class TestJavaClassBuilder
    extends JavaClassBuilder<TestJavaClass> {
        private final boolean editable;

        private TestJavaClassBuilder(boolean editable) {
            this.editable = editable;
        }

        protected List<String> checkForSpecificErrors() {
            return new ArrayList<String>();
        }

        protected TestJavaClass constructClass() {
            return new TestJavaClass(this.editable, this.isInnerClass, this.packageName, this.imports, this.staticImports, this.javadoc, this.annotations, this.visibility, this.isStatic, this.className, this.superClassName, this.innerClasses, this.fields, this.methods);
        }
    }

    private static class TestJavaClass
    extends JavaClass {
        private TestJavaClass(boolean editable, boolean isInnerClass, String packageName, List<String> imports, List<String> staticImports, Javadoc javadoc, List<JavaAnnotation> annotations, Visibility visibility, boolean isStatic, String className, String superClassName, List<JavaClass> innerClasses, List<JavaField> fields, List<JavaMethod> methods) {
            super(editable, isInnerClass, packageName, imports, staticImports, javadoc, annotations, visibility, isStatic, className, superClassName, innerClasses, fields, methods);
        }
    }
}

