/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.JavaAnnotation;
import com.github.tadukoo.java.JavaField;
import com.github.tadukoo.java.JavaFieldBuilder;
import com.github.tadukoo.java.Javadoc;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.uneditable.UneditableJavaAnnotation;
import com.github.tadukoo.java.uneditable.UneditableJavadoc;
import com.github.tadukoo.util.ListUtil;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JavaFieldBuilderTest {
    private TestJavaField field;
    private String type;
    private String name;

    @BeforeEach
    public void setup() {
        this.type = "int";
        this.name = "test";
        this.field = (TestJavaField)new TestJavaFieldBuilder().type(this.type).name(this.name).build();
    }

    @Test
    public void testDefaultSectionComment() {
        Assertions.assertNull((Object)this.field.getSectionComment());
    }

    @Test
    public void testDefaultJavadoc() {
        Assertions.assertNull((Object)this.field.getJavadoc());
    }

    @Test
    public void testDefaultAnnotations() {
        Assertions.assertTrue((boolean)this.field.getAnnotations().isEmpty());
    }

    @Test
    public void testDefaultVisibility() {
        Assertions.assertEquals((Object)Visibility.PRIVATE, (Object)this.field.getVisibility());
    }

    @Test
    public void testDefaultIsStatic() {
        Assertions.assertFalse((boolean)this.field.isStatic());
    }

    @Test
    public void testDefaultIsFinal() {
        Assertions.assertFalse((boolean)this.field.isFinal());
    }

    @Test
    public void testDefaultValue() {
        Assertions.assertNull((Object)this.field.getValue());
    }

    @Test
    public void testSetType() {
        Assertions.assertEquals((Object)"int", (Object)this.field.getType());
    }

    @Test
    public void testSetName() {
        Assertions.assertEquals((Object)"test", (Object)this.field.getName());
    }

    @Test
    public void testSetSectionComment() {
        this.field = (TestJavaField)new TestJavaFieldBuilder().type(this.type).name(this.name).sectionComment("Test comment").build();
        Assertions.assertEquals((Object)"Test comment", (Object)this.field.getSectionComment());
    }

    @Test
    public void testSetJavadoc() {
        Javadoc doc = UneditableJavadoc.builder().build();
        this.field = (TestJavaField)new TestJavaFieldBuilder().type(this.type).name(this.name).javadoc(doc).build();
        Assertions.assertEquals((Object)doc, (Object)this.field.getJavadoc());
    }

    @Test
    public void testSetAnnotations() {
        JavaAnnotation test = UneditableJavaAnnotation.builder().name("Test").build();
        JavaAnnotation derp = UneditableJavaAnnotation.builder().name("Derp").build();
        List annotations = ListUtil.createList((Object[])new JavaAnnotation[]{test, derp});
        this.field = (TestJavaField)new TestJavaFieldBuilder().annotations(annotations).type(this.type).name(this.name).build();
        Assertions.assertEquals((Object)annotations, (Object)this.field.getAnnotations());
    }

    @Test
    public void testSetAnnotation() {
        JavaAnnotation test = UneditableJavaAnnotation.builder().name("Test").build();
        this.field = (TestJavaField)new TestJavaFieldBuilder().annotation(test).type(this.type).name("Test").build();
        List annotations = this.field.getAnnotations();
        Assertions.assertEquals((int)1, (int)annotations.size());
        Assertions.assertEquals((Object)test, annotations.get(0));
    }

    @Test
    public void testSetVisibility() {
        this.field = (TestJavaField)new TestJavaFieldBuilder().visibility(Visibility.PUBLIC).type(this.type).name(this.name).build();
        Assertions.assertEquals((Object)Visibility.PUBLIC, (Object)this.field.getVisibility());
    }

    @Test
    public void testSetIsStatic() {
        this.field = (TestJavaField)new TestJavaFieldBuilder().type(this.type).name(this.name).isStatic(false).build();
        Assertions.assertFalse((boolean)this.field.isStatic());
        this.field = (TestJavaField)new TestJavaFieldBuilder().type(this.type).name(this.name).isStatic(true).build();
        Assertions.assertTrue((boolean)this.field.isStatic());
    }

    @Test
    public void testIsStatic() {
        this.field = (TestJavaField)new TestJavaFieldBuilder().type(this.type).name(this.name).isStatic().build();
        Assertions.assertTrue((boolean)this.field.isStatic());
    }

    @Test
    public void testSetIsFinal() {
        this.field = (TestJavaField)new TestJavaFieldBuilder().type(this.type).name(this.name).isFinal(false).build();
        Assertions.assertFalse((boolean)this.field.isFinal());
        this.field = (TestJavaField)new TestJavaFieldBuilder().type(this.type).name(this.name).isFinal(true).build();
        Assertions.assertTrue((boolean)this.field.isFinal());
    }

    @Test
    public void testIsFinal() {
        this.field = (TestJavaField)new TestJavaFieldBuilder().type(this.type).name(this.name).isFinal().build();
        Assertions.assertTrue((boolean)this.field.isFinal());
    }

    @Test
    public void testSetValue() {
        this.field = (TestJavaField)new TestJavaFieldBuilder().type(this.type).name(this.name).value("42").build();
        Assertions.assertEquals((Object)"42", (Object)this.field.getValue());
    }

    @Test
    public void testNullType() {
        try {
            this.field = (TestJavaField)new TestJavaFieldBuilder().name(this.name).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Must specify type!", (Object)e.getMessage());
        }
    }

    @Test
    public void testNullName() {
        try {
            this.field = (TestJavaField)new TestJavaFieldBuilder().type(this.type).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Must specify name!", (Object)e.getMessage());
        }
    }

    @Test
    public void testNullTypeAndName() {
        try {
            this.field = (TestJavaField)new TestJavaFieldBuilder().build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Must specify type!\nMust specify name!", (Object)e.getMessage());
        }
    }

    private static class TestJavaFieldBuilder
    extends JavaFieldBuilder<TestJavaField> {
        private TestJavaFieldBuilder() {
        }

        protected List<String> checkForSpecificErrors() {
            return new ArrayList<String>();
        }

        protected TestJavaField constructField() {
            return new TestJavaField(this.sectionComment, this.javadoc, this.annotations, this.visibility, this.isStatic, this.isFinal, this.type, this.name, this.value);
        }
    }

    private static class TestJavaField
    extends JavaField {
        protected TestJavaField(String sectionComment, Javadoc javadoc, List<JavaAnnotation> annotations, Visibility visibility, boolean isStatic, boolean isFinal, String type, String name, String value) {
            super(false, sectionComment, javadoc, annotations, visibility, isStatic, isFinal, type, name, value);
        }
    }
}

