/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.JavaAnnotation;
import com.github.tadukoo.java.JavaMethod;
import com.github.tadukoo.java.JavaMethodBuilder;
import com.github.tadukoo.java.Javadoc;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.uneditable.UneditableJavaAnnotation;
import com.github.tadukoo.java.uneditable.UneditableJavadoc;
import com.github.tadukoo.util.tuple.Pair;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JavaMethodTest {
    private JavaMethod method;
    private String returnType;

    @BeforeEach
    public void setup() {
        this.returnType = "int";
        this.method = new TestJavaMethodBuilder(false).returnType(this.returnType).build();
    }

    @Test
    public void testIsEditable() {
        Assertions.assertFalse((boolean)this.method.isEditable());
    }

    @Test
    public void testIsEditableTrue() {
        this.method = new TestJavaMethodBuilder(true).returnType(this.returnType).build();
        Assertions.assertTrue((boolean)this.method.isEditable());
    }

    @Test
    public void testToString() {
        String javaString = "public int(){\n}";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithSectionComment() {
        this.method = new TestJavaMethodBuilder(false).returnType(this.returnType).sectionComment("Test comment").build();
        String javaString = "/*\n * Test comment\n */\n\npublic int(){\n}";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithJavadoc() {
        this.method = new TestJavaMethodBuilder(false).returnType(this.returnType).javadoc(UneditableJavadoc.builder().build()).build();
        String javaString = "/**\n */\npublic int(){\n}";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithSingleAnnotation() {
        JavaAnnotation test = UneditableJavaAnnotation.builder().name("Test").build();
        this.method = new TestJavaMethodBuilder(false).returnType(this.returnType).annotation(test).build();
        String javaString = "@Test\npublic int(){\n}";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithAnnotations() {
        JavaAnnotation test = UneditableJavaAnnotation.builder().name("Test").build();
        JavaAnnotation derp = UneditableJavaAnnotation.builder().name("Derp").build();
        this.method = new TestJavaMethodBuilder(false).returnType(this.returnType).annotation(test).annotation(derp).build();
        String javaString = "@Test\n@Derp\npublic int(){\n}";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithIsStatic() {
        this.method = new TestJavaMethodBuilder(false).returnType(this.returnType).isStatic().build();
        String javaString = "public static int(){\n}";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithName() {
        this.method = new TestJavaMethodBuilder(false).returnType(this.returnType).name("someMethod").build();
        String javaString = "public int someMethod(){\n}";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithSingleParameter() {
        this.method = new TestJavaMethodBuilder(false).returnType(this.returnType).parameter("String", "text").build();
        String javaString = "public int(String text){\n}";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithParameters() {
        this.method = new TestJavaMethodBuilder(false).returnType(this.returnType).parameter("String", "text").parameter("int", "something").build();
        String javaString = "public int(String text, int something){\n}";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithSingleThrowType() {
        this.method = new TestJavaMethodBuilder(false).returnType(this.returnType).throwType("Throwable").build();
        String javaString = "public int() throws Throwable{\n}";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithThrowTypes() {
        this.method = new TestJavaMethodBuilder(false).returnType(this.returnType).throwType("Throwable").throwType("Exception").build();
        String javaString = "public int() throws Throwable, Exception{\n}";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithLines() {
        this.method = new TestJavaMethodBuilder(false).returnType(this.returnType).line("doSomething();").line("return 42;").build();
        String javaString = "public int(){\n\tdoSomething();\n\treturn 42;\n}";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithEverything() {
        JavaAnnotation test = UneditableJavaAnnotation.builder().name("Test").build();
        JavaAnnotation derp = UneditableJavaAnnotation.builder().name("Derp").build();
        this.method = new TestJavaMethodBuilder(false).returnType(this.returnType).sectionComment("Test comment").javadoc(UneditableJavadoc.builder().build()).annotation(test).annotation(derp).name("someMethod").isStatic().parameter("String", "text").parameter("int", "something").throwType("Throwable").throwType("Exception").line("doSomething();").line("return 42;").build();
        String javaString = "/*\n * Test comment\n */\n\n/**\n */\n@Test\n@Derp\npublic static int someMethod(String text, int something) throws Throwable, Exception{\n\tdoSomething();\n\treturn 42;\n}";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testEquals() {
        JavaAnnotation test = UneditableJavaAnnotation.builder().name("Test").build();
        JavaAnnotation derp = UneditableJavaAnnotation.builder().name("Derp").build();
        this.method = new TestJavaMethodBuilder(false).returnType(this.returnType).sectionComment("Test comment").javadoc(UneditableJavadoc.builder().build()).annotation(test).annotation(derp).name("someMethod").isStatic().parameter("String", "text").parameter("int", "something").throwType("Throwable").throwType("Exception").line("doSomething();").line("return 42;").build();
        JavaMethod otherMethod = new TestJavaMethodBuilder(false).returnType(this.returnType).sectionComment("Test comment").javadoc(UneditableJavadoc.builder().build()).annotation(test).annotation(derp).name("someMethod").isStatic().parameter("String", "text").parameter("int", "something").throwType("Throwable").throwType("Exception").line("doSomething();").line("return 42;").build();
        Assertions.assertEquals((Object)this.method, (Object)otherMethod);
    }

    @Test
    public void testEqualsNotEqual() {
        JavaAnnotation test = UneditableJavaAnnotation.builder().name("Test").build();
        JavaAnnotation derp = UneditableJavaAnnotation.builder().name("Derp").build();
        this.method = new TestJavaMethodBuilder(false).returnType(this.returnType).sectionComment("Test comment").javadoc(UneditableJavadoc.builder().build()).annotation(test).annotation(derp).name("someMethod").isStatic().parameter("String", "text").parameter("int", "something").throwType("Throwable").throwType("Exception").line("doSomething();").line("return 42;").build();
        JavaMethod otherMethod = new TestJavaMethodBuilder(false).returnType(this.returnType).sectionComment("Test comment").javadoc(UneditableJavadoc.builder().build()).annotation(test).annotation(derp).name("someMethod").isStatic().parameter("String", "text").parameter("int", "something").throwType("Throwable").throwType("Exception").line("doSomething();").line("return 41;").build();
        Assertions.assertNotEquals((Object)this.method, (Object)otherMethod);
    }

    @Test
    public void testEqualsDifferentTypes() {
        Assertions.assertNotEquals((Object)this.method, (Object)"testing");
    }

    private static class TestJavaMethodBuilder
    extends JavaMethodBuilder<TestJavaMethod> {
        private final boolean editable;

        private TestJavaMethodBuilder(boolean editable) {
            this.editable = editable;
        }

        protected List<String> checkForSpecificErrors() {
            return new ArrayList<String>();
        }

        protected TestJavaMethod constructMethod() {
            return new TestJavaMethod(this.editable, this.sectionComment, this.javadoc, this.annotations, this.visibility, this.isStatic, this.returnType, this.name, this.parameters, this.throwTypes, this.lines);
        }
    }

    private static class TestJavaMethod
    extends JavaMethod {
        private TestJavaMethod(boolean editable, String sectionComment, Javadoc javadoc, List<JavaAnnotation> annotations, Visibility visibility, boolean isStatic, String returnType, String name, List<Pair<String, String>> parameters, List<String> throwTypes, List<String> lines) {
            super(editable, sectionComment, javadoc, annotations, visibility, isStatic, returnType, name, parameters, throwTypes, lines);
        }
    }
}

