/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.editable;

import com.github.tadukoo.java.DefaultJavaClassTest;
import com.github.tadukoo.java.JavaAnnotation;
import com.github.tadukoo.java.JavaClass;
import com.github.tadukoo.java.JavaField;
import com.github.tadukoo.java.JavaMethod;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.editable.EditableJavaAnnotation;
import com.github.tadukoo.java.editable.EditableJavaClass;
import com.github.tadukoo.java.editable.EditableJavaField;
import com.github.tadukoo.java.editable.EditableJavaMethod;
import com.github.tadukoo.java.editable.EditableJavadoc;
import com.github.tadukoo.java.uneditable.UneditableJavaAnnotation;
import com.github.tadukoo.java.uneditable.UneditableJavaClass;
import com.github.tadukoo.java.uneditable.UneditableJavaField;
import com.github.tadukoo.java.uneditable.UneditableJavaMethod;
import com.github.tadukoo.java.uneditable.UneditableJavadoc;
import com.github.tadukoo.util.ListUtil;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EditableJavaClassTest
extends DefaultJavaClassTest<EditableJavaClass> {
    public EditableJavaClassTest() {
        super(EditableJavaClass::builder, EditableJavaAnnotation::builder, EditableJavadoc::builder, EditableJavaField::builder, EditableJavaMethod::builder);
    }

    @Test
    public void testIsEditable() {
        Assertions.assertTrue((boolean)((EditableJavaClass)this.clazz).isEditable());
    }

    @Test
    public void testBuilderUneditableJavadocError() {
        try {
            EditableJavaClass.builder().packageName(this.packageName).className(this.className).javadoc(UneditableJavadoc.builder().build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"javadoc is not editable in this editable JavaClass", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderUneditableAnnotationError() {
        try {
            EditableJavaClass.builder().packageName(this.packageName).className(this.className).annotation(UneditableJavaAnnotation.builder().name("Test").build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"some annotations are not editable in this editable JavaClass", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderUneditableInnerClassError() {
        try {
            EditableJavaClass.builder().packageName(this.packageName).className(this.className).innerClass(UneditableJavaClass.builder().innerClass().className(this.className).build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"some inner classes are not editable in this editable JavaClass", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderUneditableFieldError() {
        try {
            EditableJavaClass.builder().packageName(this.packageName).className(this.className).field(UneditableJavaField.builder().type("String").name("test").build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"some fields are not editable in this editable JavaClass", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderUneditableMethodError() {
        try {
            EditableJavaClass.builder().packageName(this.packageName).className(this.className).method(UneditableJavaMethod.builder().returnType("String").name("test").build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"some methods are not editable in this editable JavaClass", (Object)e.getMessage());
        }
    }

    @Test
    public void testAllBuilderSpecificErrors() {
        try {
            EditableJavaClass.builder().packageName(this.packageName).className(this.className).javadoc(UneditableJavadoc.builder().build()).annotation(UneditableJavaAnnotation.builder().name("Test").build()).innerClass(UneditableJavaClass.builder().innerClass().className(this.className).build()).field(UneditableJavaField.builder().type("String").name("test").build()).method(UneditableJavaMethod.builder().returnType("String").name("test").build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"javadoc is not editable in this editable JavaClass\nsome annotations are not editable in this editable JavaClass\nsome inner classes are not editable in this editable JavaClass\nsome fields are not editable in this editable JavaClass\nsome methods are not editable in this editable JavaClass", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetInnerClass() {
        Assertions.assertFalse((boolean)((EditableJavaClass)this.clazz).isInnerClass());
        ((EditableJavaClass)this.clazz).setInnerClass(false);
        Assertions.assertFalse((boolean)((EditableJavaClass)this.clazz).isInnerClass());
        ((EditableJavaClass)this.clazz).setInnerClass(true);
        Assertions.assertTrue((boolean)((EditableJavaClass)this.clazz).isInnerClass());
    }

    @Test
    public void testSetPackageName() {
        Assertions.assertEquals((Object)this.packageName, (Object)((EditableJavaClass)this.clazz).getPackageName());
        ((EditableJavaClass)this.clazz).setPackageName("some.random.package.name");
        Assertions.assertEquals((Object)"some.random.package.name", (Object)((EditableJavaClass)this.clazz).getPackageName());
    }

    @Test
    public void testAddImport() {
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getImports());
        ((EditableJavaClass)this.clazz).addImport("some.import");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"some.import"}), (Object)((EditableJavaClass)this.clazz).getImports());
        ((EditableJavaClass)this.clazz).addImport("some.other.import");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"some.import", "some.other.import"}), (Object)((EditableJavaClass)this.clazz).getImports());
    }

    @Test
    public void testAddImports() {
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getImports());
        ((EditableJavaClass)this.clazz).addImports(ListUtil.createList((Object[])new String[]{"some.import", "some.other.import"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"some.import", "some.other.import"}), (Object)((EditableJavaClass)this.clazz).getImports());
        ((EditableJavaClass)this.clazz).addImports(ListUtil.createList((Object[])new String[]{"com.github.tadukoo", "derp.yep"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"some.import", "some.other.import", "com.github.tadukoo", "derp.yep"}), (Object)((EditableJavaClass)this.clazz).getImports());
    }

    @Test
    public void testSetImports() {
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getImports());
        ((EditableJavaClass)this.clazz).setImports(ListUtil.createList((Object[])new String[]{"some.import", "some.other.import"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"some.import", "some.other.import"}), (Object)((EditableJavaClass)this.clazz).getImports());
        ((EditableJavaClass)this.clazz).setImports(ListUtil.createList((Object[])new String[]{"com.github.tadukoo", "derp.yep"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"com.github.tadukoo", "derp.yep"}), (Object)((EditableJavaClass)this.clazz).getImports());
    }

    @Test
    public void testAddStaticImport() {
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getStaticImports());
        ((EditableJavaClass)this.clazz).addStaticImport("some.import");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"some.import"}), (Object)((EditableJavaClass)this.clazz).getStaticImports());
        ((EditableJavaClass)this.clazz).addStaticImport("some.other.import");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"some.import", "some.other.import"}), (Object)((EditableJavaClass)this.clazz).getStaticImports());
    }

    @Test
    public void testAddStaticImports() {
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getStaticImports());
        ((EditableJavaClass)this.clazz).addStaticImports(ListUtil.createList((Object[])new String[]{"some.import", "some.other.import"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"some.import", "some.other.import"}), (Object)((EditableJavaClass)this.clazz).getStaticImports());
        ((EditableJavaClass)this.clazz).addStaticImports(ListUtil.createList((Object[])new String[]{"com.github.tadukoo", "derp.yep"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"some.import", "some.other.import", "com.github.tadukoo", "derp.yep"}), (Object)((EditableJavaClass)this.clazz).getStaticImports());
    }

    @Test
    public void testSetStaticImports() {
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getStaticImports());
        ((EditableJavaClass)this.clazz).setStaticImports(ListUtil.createList((Object[])new String[]{"some.import", "some.other.import"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"some.import", "some.other.import"}), (Object)((EditableJavaClass)this.clazz).getStaticImports());
        ((EditableJavaClass)this.clazz).setStaticImports(ListUtil.createList((Object[])new String[]{"com.github.tadukoo", "derp.yep"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"com.github.tadukoo", "derp.yep"}), (Object)((EditableJavaClass)this.clazz).getStaticImports());
    }

    @Test
    public void testSetJavadoc() {
        Assertions.assertNull((Object)((EditableJavaClass)this.clazz).getJavadoc());
        ((EditableJavaClass)this.clazz).setJavadoc(EditableJavadoc.builder().build());
        Assertions.assertEquals((Object)EditableJavadoc.builder().build(), (Object)((EditableJavaClass)this.clazz).getJavadoc());
    }

    @Test
    public void testSetJavadocUneditable() {
        try {
            ((EditableJavaClass)this.clazz).setJavadoc(UneditableJavadoc.builder().build());
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable Javadoc", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddAnnotation() {
        JavaAnnotation test = EditableJavaAnnotation.builder().name("Test").build();
        JavaAnnotation derp = EditableJavaAnnotation.builder().name("Derp").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getAnnotations());
        ((EditableJavaClass)this.clazz).addAnnotation(test);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{test}), (Object)((EditableJavaClass)this.clazz).getAnnotations());
        ((EditableJavaClass)this.clazz).addAnnotation(derp);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}), (Object)((EditableJavaClass)this.clazz).getAnnotations());
    }

    @Test
    public void testAddAnnotationUneditable() {
        try {
            ((EditableJavaClass)this.clazz).addAnnotation(UneditableJavaAnnotation.builder().name("Test").build());
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable Java Annotations", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddAnnotations() {
        JavaAnnotation test = EditableJavaAnnotation.builder().name("Test").build();
        JavaAnnotation derp = EditableJavaAnnotation.builder().name("Derp").build();
        JavaAnnotation blah = EditableJavaAnnotation.builder().name("Blah").build();
        JavaAnnotation yep = EditableJavaAnnotation.builder().name("yep").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getAnnotations());
        ((EditableJavaClass)this.clazz).addAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}), (Object)((EditableJavaClass)this.clazz).getAnnotations());
        ((EditableJavaClass)this.clazz).addAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{blah, yep}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{test, derp, blah, yep}), (Object)((EditableJavaClass)this.clazz).getAnnotations());
    }

    @Test
    public void testAddAnnotationsUneditable() {
        try {
            ((EditableJavaClass)this.clazz).addAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{UneditableJavaAnnotation.builder().name("Test").build(), UneditableJavaAnnotation.builder().name("Derp").build()}));
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable Java Annotations", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetAnnotations() {
        JavaAnnotation test = EditableJavaAnnotation.builder().name("Test").build();
        JavaAnnotation derp = EditableJavaAnnotation.builder().name("Derp").build();
        JavaAnnotation blah = EditableJavaAnnotation.builder().name("Blah").build();
        JavaAnnotation yep = EditableJavaAnnotation.builder().name("yep").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getAnnotations());
        ((EditableJavaClass)this.clazz).setAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}), (Object)((EditableJavaClass)this.clazz).getAnnotations());
        ((EditableJavaClass)this.clazz).setAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{blah, yep}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{blah, yep}), (Object)((EditableJavaClass)this.clazz).getAnnotations());
    }

    @Test
    public void testSetAnnotationsUneditable() {
        try {
            ((EditableJavaClass)this.clazz).setAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{UneditableJavaAnnotation.builder().name("Test").build(), UneditableJavaAnnotation.builder().name("Derp").build()}));
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable Java Annotations", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetVisibility() {
        Assertions.assertEquals((Object)Visibility.PUBLIC, (Object)((EditableJavaClass)this.clazz).getVisibility());
        ((EditableJavaClass)this.clazz).setVisibility(Visibility.PRIVATE);
        Assertions.assertEquals((Object)Visibility.PRIVATE, (Object)((EditableJavaClass)this.clazz).getVisibility());
    }

    @Test
    public void testSetStatic() {
        Assertions.assertFalse((boolean)((EditableJavaClass)this.clazz).isStatic());
        ((EditableJavaClass)this.clazz).setStatic(false);
        Assertions.assertFalse((boolean)((EditableJavaClass)this.clazz).isStatic());
        ((EditableJavaClass)this.clazz).setStatic(true);
        Assertions.assertTrue((boolean)((EditableJavaClass)this.clazz).isStatic());
    }

    @Test
    public void testSetClassName() {
        Assertions.assertEquals((Object)this.className, (Object)((EditableJavaClass)this.clazz).getClassName());
        ((EditableJavaClass)this.clazz).setClassName("SomethingElse");
        Assertions.assertEquals((Object)"SomethingElse", (Object)((EditableJavaClass)this.clazz).getClassName());
    }

    @Test
    public void testSetSuperClassName() {
        Assertions.assertNull((Object)((EditableJavaClass)this.clazz).getSuperClassName());
        ((EditableJavaClass)this.clazz).setSuperClassName("SomethingElse");
        Assertions.assertEquals((Object)"SomethingElse", (Object)((EditableJavaClass)this.clazz).getSuperClassName());
    }

    @Test
    public void testAddInnerClass() {
        JavaClass clazz1 = EditableJavaClass.builder().packageName("a.package").className("Test").build();
        JavaClass clazz2 = EditableJavaClass.builder().packageName("package.b").className("Derp").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getInnerClasses());
        ((EditableJavaClass)this.clazz).addInnerClass(clazz1);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaClass[]{clazz1}), (Object)((EditableJavaClass)this.clazz).getInnerClasses());
        ((EditableJavaClass)this.clazz).addInnerClass(clazz2);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaClass[]{clazz1, clazz2}), (Object)((EditableJavaClass)this.clazz).getInnerClasses());
    }

    @Test
    public void testAddInnerClassUneditable() {
        try {
            ((EditableJavaClass)this.clazz).addInnerClass(UneditableJavaClass.builder().packageName("a.package").className("Test").build());
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable inner classes", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddInnerClasses() {
        JavaClass clazz1 = EditableJavaClass.builder().packageName("a.package").className("Test").build();
        JavaClass clazz2 = EditableJavaClass.builder().packageName("package.b").className("Derp").build();
        JavaClass clazz3 = EditableJavaClass.builder().packageName("package.c").className("Blah").build();
        JavaClass clazz4 = EditableJavaClass.builder().packageName("package.d").className("Yep").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getInnerClasses());
        ((EditableJavaClass)this.clazz).addInnerClasses(ListUtil.createList((Object[])new JavaClass[]{clazz1, clazz2}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaClass[]{clazz1, clazz2}), (Object)((EditableJavaClass)this.clazz).getInnerClasses());
        ((EditableJavaClass)this.clazz).addInnerClasses(ListUtil.createList((Object[])new JavaClass[]{clazz3, clazz4}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaClass[]{clazz1, clazz2, clazz3, clazz4}), (Object)((EditableJavaClass)this.clazz).getInnerClasses());
    }

    @Test
    public void testAddInnerClassesUneditable() {
        try {
            ((EditableJavaClass)this.clazz).addInnerClasses(ListUtil.createList((Object[])new JavaClass[]{UneditableJavaClass.builder().packageName("a.package").className("Test").build(), UneditableJavaClass.builder().packageName("b.package").className("Derp").build()}));
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable inner classes", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetInnerClasses() {
        JavaClass clazz1 = EditableJavaClass.builder().packageName("a.package").className("Test").build();
        JavaClass clazz2 = EditableJavaClass.builder().packageName("package.b").className("Derp").build();
        JavaClass clazz3 = EditableJavaClass.builder().packageName("package.c").className("Blah").build();
        JavaClass clazz4 = EditableJavaClass.builder().packageName("package.d").className("Yep").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getInnerClasses());
        ((EditableJavaClass)this.clazz).setInnerClasses(ListUtil.createList((Object[])new JavaClass[]{clazz1, clazz2}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaClass[]{clazz1, clazz2}), (Object)((EditableJavaClass)this.clazz).getInnerClasses());
        ((EditableJavaClass)this.clazz).setInnerClasses(ListUtil.createList((Object[])new JavaClass[]{clazz3, clazz4}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaClass[]{clazz3, clazz4}), (Object)((EditableJavaClass)this.clazz).getInnerClasses());
    }

    @Test
    public void testSetInnerClassesUneditable() {
        try {
            ((EditableJavaClass)this.clazz).setInnerClasses(ListUtil.createList((Object[])new JavaClass[]{UneditableJavaClass.builder().packageName("a.package").className("Test").build(), UneditableJavaClass.builder().packageName("b.package").className("Derp").build()}));
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable inner classes", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddField() {
        JavaField field1 = EditableJavaField.builder().type("String").name("test").build();
        JavaField field2 = EditableJavaField.builder().type("int").name("derp").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getFields());
        ((EditableJavaClass)this.clazz).addField(field1);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaField[]{field1}), (Object)((EditableJavaClass)this.clazz).getFields());
        ((EditableJavaClass)this.clazz).addField(field2);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaField[]{field1, field2}), (Object)((EditableJavaClass)this.clazz).getFields());
    }

    @Test
    public void testAddFieldUneditable() {
        try {
            ((EditableJavaClass)this.clazz).addField(UneditableJavaField.builder().type("String").name("test").build());
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable Java Fields", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddFields() {
        JavaField field1 = EditableJavaField.builder().type("String").name("test").build();
        JavaField field2 = EditableJavaField.builder().type("int").name("derp").build();
        JavaField field3 = EditableJavaField.builder().type("String").name("blah").build();
        JavaField field4 = EditableJavaField.builder().type("double").name("yep").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getFields());
        ((EditableJavaClass)this.clazz).addFields(ListUtil.createList((Object[])new JavaField[]{field1, field2}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaField[]{field1, field2}), (Object)((EditableJavaClass)this.clazz).getFields());
        ((EditableJavaClass)this.clazz).addFields(ListUtil.createList((Object[])new JavaField[]{field3, field4}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaField[]{field1, field2, field3, field4}), (Object)((EditableJavaClass)this.clazz).getFields());
    }

    @Test
    public void testAddFieldsUneditable() {
        try {
            ((EditableJavaClass)this.clazz).addFields(ListUtil.createList((Object[])new JavaField[]{UneditableJavaField.builder().type("String").name("test").build(), UneditableJavaField.builder().type("int").name("derp").build()}));
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable Java Fields", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetFields() {
        JavaField field1 = EditableJavaField.builder().type("String").name("test").build();
        JavaField field2 = EditableJavaField.builder().type("int").name("derp").build();
        JavaField field3 = EditableJavaField.builder().type("String").name("blah").build();
        JavaField field4 = EditableJavaField.builder().type("double").name("yep").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getFields());
        ((EditableJavaClass)this.clazz).setFields(ListUtil.createList((Object[])new JavaField[]{field1, field2}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaField[]{field1, field2}), (Object)((EditableJavaClass)this.clazz).getFields());
        ((EditableJavaClass)this.clazz).setFields(ListUtil.createList((Object[])new JavaField[]{field3, field4}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaField[]{field3, field4}), (Object)((EditableJavaClass)this.clazz).getFields());
    }

    @Test
    public void testSetFieldsUneditable() {
        try {
            ((EditableJavaClass)this.clazz).setFields(ListUtil.createList((Object[])new JavaField[]{UneditableJavaField.builder().type("String").name("test").build(), UneditableJavaField.builder().type("int").name("derp").build()}));
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable Java Fields", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddMethod() {
        JavaMethod method1 = EditableJavaMethod.builder().returnType("String").name("test").build();
        JavaMethod method2 = EditableJavaMethod.builder().returnType("int").name("derp").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getMethods());
        ((EditableJavaClass)this.clazz).addMethod(method1);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaMethod[]{method1}), (Object)((EditableJavaClass)this.clazz).getMethods());
        ((EditableJavaClass)this.clazz).addMethod(method2);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaMethod[]{method1, method2}), (Object)((EditableJavaClass)this.clazz).getMethods());
    }

    @Test
    public void testAddMethodUneditable() {
        try {
            ((EditableJavaClass)this.clazz).addMethod(UneditableJavaMethod.builder().returnType("String").name("test").build());
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable Java Methods", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddMethods() {
        JavaMethod method1 = EditableJavaMethod.builder().returnType("String").name("test").build();
        JavaMethod method2 = EditableJavaMethod.builder().returnType("int").name("derp").build();
        JavaMethod method3 = EditableJavaMethod.builder().returnType("String").name("blah").build();
        JavaMethod method4 = EditableJavaMethod.builder().returnType("double").name("yep").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getMethods());
        ((EditableJavaClass)this.clazz).addMethods(ListUtil.createList((Object[])new JavaMethod[]{method1, method2}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaMethod[]{method1, method2}), (Object)((EditableJavaClass)this.clazz).getMethods());
        ((EditableJavaClass)this.clazz).addMethods(ListUtil.createList((Object[])new JavaMethod[]{method3, method4}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaMethod[]{method1, method2, method3, method4}), (Object)((EditableJavaClass)this.clazz).getMethods());
    }

    @Test
    public void testAddMethodsUneditable() {
        try {
            ((EditableJavaClass)this.clazz).addMethods(ListUtil.createList((Object[])new JavaMethod[]{UneditableJavaMethod.builder().returnType("String").name("test").build(), UneditableJavaMethod.builder().returnType("int").name("derp").build()}));
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable Java Methods", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetMethods() {
        JavaMethod method1 = EditableJavaMethod.builder().returnType("String").name("test").build();
        JavaMethod method2 = EditableJavaMethod.builder().returnType("int").name("derp").build();
        JavaMethod method3 = EditableJavaMethod.builder().returnType("String").name("blah").build();
        JavaMethod method4 = EditableJavaMethod.builder().returnType("double").name("yep").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaClass)this.clazz).getMethods());
        ((EditableJavaClass)this.clazz).setMethods(ListUtil.createList((Object[])new JavaMethod[]{method1, method2}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaMethod[]{method1, method2}), (Object)((EditableJavaClass)this.clazz).getMethods());
        ((EditableJavaClass)this.clazz).setMethods(ListUtil.createList((Object[])new JavaMethod[]{method3, method4}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaMethod[]{method3, method4}), (Object)((EditableJavaClass)this.clazz).getMethods());
    }

    @Test
    public void testSetMethodsUneditable() {
        try {
            ((EditableJavaClass)this.clazz).setMethods(ListUtil.createList((Object[])new JavaMethod[]{UneditableJavaMethod.builder().returnType("String").name("test").build(), UneditableJavaMethod.builder().returnType("int").name("derp").build()}));
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Class requires editable Java Methods", (Object)e.getMessage());
        }
    }
}

