/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.editable;

import com.github.tadukoo.java.DefaultJavaFieldTest;
import com.github.tadukoo.java.JavaAnnotation;
import com.github.tadukoo.java.Javadoc;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.editable.EditableJavaAnnotation;
import com.github.tadukoo.java.editable.EditableJavaField;
import com.github.tadukoo.java.editable.EditableJavadoc;
import com.github.tadukoo.java.uneditable.UneditableJavaAnnotation;
import com.github.tadukoo.java.uneditable.UneditableJavadoc;
import com.github.tadukoo.util.ListUtil;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EditableJavaFieldTest
extends DefaultJavaFieldTest<EditableJavaField> {
    protected EditableJavaFieldTest() {
        super(EditableJavaField::builder, EditableJavadoc::builder, EditableJavaAnnotation::builder);
    }

    @Test
    public void testIsEditable() {
        Assertions.assertTrue((boolean)((EditableJavaField)this.field).isEditable());
    }

    @Test
    public void testBuilderErrorEditableJavadoc() {
        try {
            EditableJavaField.builder().type("int").name("test").javadoc(UneditableJavadoc.builder().build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"javadoc is not editable in this editable JavaField", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderErrorEditableAnnotation() {
        try {
            EditableJavaField.builder().type("int").name("test").annotation(UneditableJavaAnnotation.builder().name("Test").build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"some annotations are not editable in this editable JavaField", (Object)e.getMessage());
        }
    }

    @Test
    public void testAllBuilderErrors() {
        try {
            EditableJavaField.builder().type("int").name("test").javadoc(UneditableJavadoc.builder().build()).annotation(UneditableJavaAnnotation.builder().name("Test").build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"javadoc is not editable in this editable JavaField\nsome annotations are not editable in this editable JavaField", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetSectionComment() {
        Assertions.assertNull((Object)((EditableJavaField)this.field).getSectionComment());
        ((EditableJavaField)this.field).setSectionComment("Test");
        Assertions.assertEquals((Object)"Test", (Object)((EditableJavaField)this.field).getSectionComment());
        ((EditableJavaField)this.field).setSectionComment("Derp");
        Assertions.assertEquals((Object)"Derp", (Object)((EditableJavaField)this.field).getSectionComment());
    }

    @Test
    public void testSetJavadoc() {
        Javadoc doc1 = EditableJavadoc.builder().build();
        Javadoc doc2 = EditableJavadoc.builder().author("Me").build();
        Assertions.assertNull((Object)((EditableJavaField)this.field).getJavadoc());
        ((EditableJavaField)this.field).setJavadoc(doc1);
        Assertions.assertEquals((Object)doc1, (Object)((EditableJavaField)this.field).getJavadoc());
        ((EditableJavaField)this.field).setJavadoc(doc2);
        Assertions.assertEquals((Object)doc2, (Object)((EditableJavaField)this.field).getJavadoc());
    }

    @Test
    public void testSetJavadocNotEditable() {
        try {
            Javadoc doc = UneditableJavadoc.builder().build();
            ((EditableJavaField)this.field).setJavadoc(doc);
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable JavaField requires an editable Javadoc", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddAnnotation() {
        JavaAnnotation test = EditableJavaAnnotation.builder().name("Test").build();
        JavaAnnotation derp = EditableJavaAnnotation.builder().name("Derp").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaField)this.field).getAnnotations());
        ((EditableJavaField)this.field).addAnnotation(test);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{test}), (Object)((EditableJavaField)this.field).getAnnotations());
        ((EditableJavaField)this.field).addAnnotation(derp);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}), (Object)((EditableJavaField)this.field).getAnnotations());
    }

    @Test
    public void testAddAnnotationNotEditable() {
        try {
            JavaAnnotation test = UneditableJavaAnnotation.builder().name("Test").build();
            ((EditableJavaField)this.field).addAnnotation(test);
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable JavaField requires editable Java Annotations", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddAnnotations() {
        JavaAnnotation test = EditableJavaAnnotation.builder().name("Test").build();
        JavaAnnotation derp = EditableJavaAnnotation.builder().name("Derp").build();
        JavaAnnotation blah = EditableJavaAnnotation.builder().name("Blah").build();
        JavaAnnotation yep = EditableJavaAnnotation.builder().name("yep").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaField)this.field).getAnnotations());
        ((EditableJavaField)this.field).addAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}), (Object)((EditableJavaField)this.field).getAnnotations());
        ((EditableJavaField)this.field).addAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{blah, yep}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{test, derp, blah, yep}), (Object)((EditableJavaField)this.field).getAnnotations());
    }

    @Test
    public void testAddAnnotationsNotEditable() {
        try {
            JavaAnnotation test = EditableJavaAnnotation.builder().name("Test").build();
            JavaAnnotation derp = UneditableJavaAnnotation.builder().name("Derp").build();
            ((EditableJavaField)this.field).addAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}));
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable JavaField requires editable Java Annotations", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetAnnotations() {
        JavaAnnotation test = EditableJavaAnnotation.builder().name("Test").build();
        JavaAnnotation derp = EditableJavaAnnotation.builder().name("Derp").build();
        JavaAnnotation blah = EditableJavaAnnotation.builder().name("Blah").build();
        JavaAnnotation yep = EditableJavaAnnotation.builder().name("yep").build();
        Assertions.assertEquals(new ArrayList(), (Object)((EditableJavaField)this.field).getAnnotations());
        ((EditableJavaField)this.field).setAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}), (Object)((EditableJavaField)this.field).getAnnotations());
        ((EditableJavaField)this.field).setAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{blah, yep}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{blah, yep}), (Object)((EditableJavaField)this.field).getAnnotations());
    }

    @Test
    public void testSetAnnotationsNotEditable() {
        try {
            JavaAnnotation test = EditableJavaAnnotation.builder().name("Test").build();
            JavaAnnotation derp = UneditableJavaAnnotation.builder().name("Derp").build();
            ((EditableJavaField)this.field).setAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}));
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable JavaField requires editable Java Annotations", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetVisibility() {
        Assertions.assertEquals((Object)Visibility.PRIVATE, (Object)((EditableJavaField)this.field).getVisibility());
        ((EditableJavaField)this.field).setVisibility(Visibility.PUBLIC);
        Assertions.assertEquals((Object)Visibility.PUBLIC, (Object)((EditableJavaField)this.field).getVisibility());
    }

    @Test
    public void testSetStatic() {
        Assertions.assertFalse((boolean)((EditableJavaField)this.field).isStatic());
        ((EditableJavaField)this.field).setStatic(true);
        Assertions.assertTrue((boolean)((EditableJavaField)this.field).isStatic());
        ((EditableJavaField)this.field).setStatic(true);
        Assertions.assertTrue((boolean)((EditableJavaField)this.field).isStatic());
    }

    @Test
    public void testSetFinal() {
        Assertions.assertFalse((boolean)((EditableJavaField)this.field).isFinal());
        ((EditableJavaField)this.field).setFinal(true);
        Assertions.assertTrue((boolean)((EditableJavaField)this.field).isFinal());
        ((EditableJavaField)this.field).setFinal(true);
        Assertions.assertTrue((boolean)((EditableJavaField)this.field).isFinal());
    }

    @Override
    @Test
    public void testSetType() {
        Assertions.assertEquals((Object)this.type, (Object)((EditableJavaField)this.field).getType());
        ((EditableJavaField)this.field).setType("String");
        Assertions.assertEquals((Object)"String", (Object)((EditableJavaField)this.field).getType());
        ((EditableJavaField)this.field).setType("double");
        Assertions.assertEquals((Object)"double", (Object)((EditableJavaField)this.field).getType());
    }

    @Override
    @Test
    public void testSetName() {
        Assertions.assertEquals((Object)this.name, (Object)((EditableJavaField)this.field).getName());
        ((EditableJavaField)this.field).setName("derp");
        Assertions.assertEquals((Object)"derp", (Object)((EditableJavaField)this.field).getName());
        ((EditableJavaField)this.field).setName("blah");
        Assertions.assertEquals((Object)"blah", (Object)((EditableJavaField)this.field).getName());
    }

    @Test
    public void testSetValue() {
        Assertions.assertNull((Object)((EditableJavaField)this.field).getValue());
        ((EditableJavaField)this.field).setValue("42");
        Assertions.assertEquals((Object)"42", (Object)((EditableJavaField)this.field).getValue());
        ((EditableJavaField)this.field).setValue("27");
        Assertions.assertEquals((Object)"27", (Object)((EditableJavaField)this.field).getValue());
    }
}

