/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.uneditable;

import com.github.tadukoo.java.DefaultJavaClassTest;
import com.github.tadukoo.java.editable.EditableJavaAnnotation;
import com.github.tadukoo.java.editable.EditableJavaClass;
import com.github.tadukoo.java.editable.EditableJavaField;
import com.github.tadukoo.java.editable.EditableJavaMethod;
import com.github.tadukoo.java.editable.EditableJavadoc;
import com.github.tadukoo.java.uneditable.UneditableJavaAnnotation;
import com.github.tadukoo.java.uneditable.UneditableJavaClass;
import com.github.tadukoo.java.uneditable.UneditableJavaField;
import com.github.tadukoo.java.uneditable.UneditableJavaMethod;
import com.github.tadukoo.java.uneditable.UneditableJavadoc;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UneditableJavaClassTest
extends DefaultJavaClassTest<UneditableJavaClass> {
    public UneditableJavaClassTest() {
        super(UneditableJavaClass::builder, UneditableJavaAnnotation::builder, UneditableJavadoc::builder, UneditableJavaField::builder, UneditableJavaMethod::builder);
    }

    @Test
    public void testIsEditable() {
        Assertions.assertFalse((boolean)((UneditableJavaClass)this.clazz).isEditable());
    }

    @Test
    public void testBuilderEditableJavadocError() {
        try {
            UneditableJavaClass.builder().packageName(this.packageName).className(this.className).javadoc(EditableJavadoc.builder().build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"javadoc is not uneditable in this uneditable JavaClass", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderEditableAnnotationError() {
        try {
            UneditableJavaClass.builder().packageName(this.packageName).className(this.className).annotation(EditableJavaAnnotation.builder().name("Test").build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"some annotations are not uneditable in this uneditable JavaClass", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderEditableInnerClassError() {
        try {
            UneditableJavaClass.builder().packageName(this.packageName).className(this.className).innerClass(EditableJavaClass.builder().innerClass().className(this.className).build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"some inner classes are not uneditable in this uneditable JavaClass", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderEditableFieldError() {
        try {
            UneditableJavaClass.builder().packageName(this.packageName).className(this.className).field(EditableJavaField.builder().type("String").name("test").build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"some fields are not uneditable in this uneditable JavaClass", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderEditableMethodError() {
        try {
            UneditableJavaClass.builder().packageName(this.packageName).className(this.className).method(EditableJavaMethod.builder().returnType("String").name("test").build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"some methods are not uneditable in this uneditable JavaClass", (Object)e.getMessage());
        }
    }

    @Test
    public void testAllBuilderSpecificErrors() {
        try {
            UneditableJavaClass.builder().packageName(this.packageName).className(this.className).javadoc(EditableJavadoc.builder().build()).annotation(EditableJavaAnnotation.builder().name("Test").build()).innerClass(EditableJavaClass.builder().innerClass().className(this.className).build()).field(EditableJavaField.builder().type("String").name("test").build()).method(EditableJavaMethod.builder().returnType("String").name("test").build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"javadoc is not uneditable in this uneditable JavaClass\nsome annotations are not uneditable in this uneditable JavaClass\nsome inner classes are not uneditable in this uneditable JavaClass\nsome fields are not uneditable in this uneditable JavaClass\nsome methods are not uneditable in this uneditable JavaClass", (Object)e.getMessage());
        }
    }
}

