/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.uneditable;

import com.github.tadukoo.java.DefaultJavaMethodTest;
import com.github.tadukoo.java.editable.EditableJavaAnnotation;
import com.github.tadukoo.java.editable.EditableJavadoc;
import com.github.tadukoo.java.uneditable.UneditableJavaAnnotation;
import com.github.tadukoo.java.uneditable.UneditableJavaMethod;
import com.github.tadukoo.java.uneditable.UneditableJavadoc;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UneditableJavaMethodTest
extends DefaultJavaMethodTest<UneditableJavaMethod> {
    public UneditableJavaMethodTest() {
        super(UneditableJavaMethod::builder, UneditableJavadoc::builder, UneditableJavaAnnotation::builder);
    }

    @Test
    public void testIsEditable() {
        Assertions.assertFalse((boolean)((UneditableJavaMethod)this.method).isEditable());
    }

    @Test
    public void testBuilderJavadocEditable() {
        try {
            UneditableJavaMethod.builder().returnType(this.returnType).javadoc(EditableJavadoc.builder().build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"javadoc is not uneditable in this uneditable JavaMethod", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderJavaAnnotationEditable() {
        try {
            UneditableJavaMethod.builder().returnType(this.returnType).annotation(EditableJavaAnnotation.builder().name("Test").build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"some annotations are not uneditable in this uneditable JavaMethod", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderAllSpecificErrors() {
        try {
            UneditableJavaMethod.builder().returnType(this.returnType).javadoc(EditableJavadoc.builder().build()).annotation(EditableJavaAnnotation.builder().name("Test").build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"javadoc is not uneditable in this uneditable JavaMethod\nsome annotations are not uneditable in this uneditable JavaMethod", (Object)e.getMessage());
        }
    }
}

