/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.JavaAnnotation;
import com.github.tadukoo.java.Javadoc;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.tuple.Pair;
import java.util.ArrayList;
import java.util.List;

public abstract class JavaMethod {
    private final boolean editable;
    protected String sectionComment;
    protected Javadoc javadoc;
    protected List<JavaAnnotation> annotations;
    protected Visibility visibility;
    protected boolean isStatic;
    protected String returnType;
    protected String name;
    protected List<Pair<String, String>> parameters;
    protected List<String> throwTypes;
    protected List<String> lines;

    protected JavaMethod(boolean editable, String sectionComment, Javadoc javadoc, List<JavaAnnotation> annotations, Visibility visibility, boolean isStatic, String returnType, String name, List<Pair<String, String>> parameters, List<String> throwTypes, List<String> lines) {
        this.editable = editable;
        this.sectionComment = sectionComment;
        this.javadoc = javadoc;
        this.annotations = annotations;
        this.visibility = visibility;
        this.isStatic = isStatic;
        this.returnType = returnType;
        this.name = name;
        this.parameters = parameters;
        this.throwTypes = throwTypes;
        this.lines = lines;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public String getSectionComment() {
        return this.sectionComment;
    }

    public Javadoc getJavadoc() {
        return this.javadoc;
    }

    public List<JavaAnnotation> getAnnotations() {
        return this.annotations;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getName() {
        return this.name;
    }

    public List<Pair<String, String>> getParameters() {
        return this.parameters;
    }

    public List<String> getThrowTypes() {
        return this.throwTypes;
    }

    public List<String> getLines() {
        return this.lines;
    }

    public String toString() {
        ArrayList<Object> content = new ArrayList<Object>();
        if (StringUtil.isNotBlank((String)this.sectionComment)) {
            content.add("/*");
            content.add(" * " + this.sectionComment);
            content.add(" */");
            content.add("");
        }
        if (this.javadoc != null) {
            content.add(this.javadoc.toString());
        }
        if (ListUtil.isNotBlank(this.annotations)) {
            for (JavaAnnotation annotation : this.annotations) {
                content.add(annotation.toString());
            }
        }
        StringBuilder declaration = new StringBuilder(this.visibility.getText() + (this.isStatic ? " static" : "") + " " + this.returnType);
        if (StringUtil.isNotBlank((String)this.name)) {
            declaration.append(" ").append(this.name);
        }
        declaration.append("(");
        if (ListUtil.isNotBlank(this.parameters)) {
            for (Pair<String, String> parameter : this.parameters) {
                declaration.append((String)parameter.getLeft()).append(" ").append((String)parameter.getRight()).append(", ");
            }
            declaration.setLength(declaration.length() - 2);
        }
        if (ListUtil.isNotBlank(this.throwTypes)) {
            declaration.append(") throws ");
            for (String throwType : this.throwTypes) {
                declaration.append(throwType).append(", ");
            }
            declaration.delete(declaration.length() - 2, declaration.length());
            declaration.append('{');
        } else {
            declaration.append("){");
        }
        content.add(declaration.toString());
        if (ListUtil.isNotBlank(this.lines)) {
            for (String line : this.lines) {
                content.add("\t" + line);
            }
        }
        content.add("}");
        return StringUtil.buildStringWithNewLines(content);
    }

    public boolean equals(Object otherMethod) {
        if (otherMethod instanceof JavaMethod) {
            JavaMethod method = (JavaMethod)otherMethod;
            return StringUtil.equals((String)this.toString(), (String)method.toString());
        }
        return false;
    }
}

