/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.uneditable;

import com.github.tadukoo.java.JavaAnnotation;
import com.github.tadukoo.java.JavaClass;
import com.github.tadukoo.java.JavaClassBuilder;
import com.github.tadukoo.java.JavaField;
import com.github.tadukoo.java.JavaMethod;
import com.github.tadukoo.java.Javadoc;
import com.github.tadukoo.java.Visibility;
import java.util.ArrayList;
import java.util.List;

public class UneditableJavaClass
extends JavaClass {
    private UneditableJavaClass(boolean isInnerClass, String packageName, List<String> imports, List<String> staticImports, Javadoc javadoc, List<JavaAnnotation> annotations, Visibility visibility, boolean isStatic, String className, String superClassName, List<JavaClass> innerClasses, List<JavaField> fields, List<JavaMethod> methods) {
        super(false, isInnerClass, packageName, imports, staticImports, javadoc, annotations, visibility, isStatic, className, superClassName, innerClasses, fields, methods);
    }

    public static UneditableJavaClassBuilder builder() {
        return new UneditableJavaClassBuilder();
    }

    public static class UneditableJavaClassBuilder
    extends JavaClassBuilder<UneditableJavaClass> {
        private UneditableJavaClassBuilder() {
        }

        @Override
        protected List<String> checkForSpecificErrors() {
            ArrayList<String> errors = new ArrayList<String>();
            if (this.javadoc != null && this.javadoc.isEditable()) {
                errors.add("javadoc is not uneditable in this uneditable JavaClass");
            }
            for (JavaAnnotation annotation : this.annotations) {
                if (!annotation.isEditable()) continue;
                errors.add("some annotations are not uneditable in this uneditable JavaClass");
                break;
            }
            for (JavaClass clazz : this.innerClasses) {
                if (!clazz.isEditable()) continue;
                errors.add("some inner classes are not uneditable in this uneditable JavaClass");
                break;
            }
            for (JavaField field : this.fields) {
                if (!field.isEditable()) continue;
                errors.add("some fields are not uneditable in this uneditable JavaClass");
                break;
            }
            for (JavaMethod method : this.methods) {
                if (!method.isEditable()) continue;
                errors.add("some methods are not uneditable in this uneditable JavaClass");
            }
            return errors;
        }

        @Override
        protected UneditableJavaClass constructClass() {
            return new UneditableJavaClass(this.isInnerClass, this.packageName, this.imports, this.staticImports, this.javadoc, this.annotations, this.visibility, this.isStatic, this.className, this.superClassName, this.innerClasses, this.fields, this.methods);
        }
    }
}

