/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.annotation;

import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.tuple.Pair;
import java.util.ArrayList;
import java.util.List;

public abstract class JavaAnnotationBuilder<AnnotationType extends JavaAnnotation> {
    protected String name;
    protected String canonicalName = "";
    protected List<Pair<String, String>> parameters = new ArrayList<Pair<String, String>>();

    protected JavaAnnotationBuilder() {
    }

    public JavaAnnotationBuilder<AnnotationType> copy(JavaAnnotation annotation) {
        this.name = annotation.getName();
        this.canonicalName = annotation.getCanonicalName();
        this.parameters = annotation.getParameters();
        return this;
    }

    public JavaAnnotationBuilder<AnnotationType> name(String name) {
        this.name = name;
        return this;
    }

    public JavaAnnotationBuilder<AnnotationType> canonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
        return this;
    }

    public JavaAnnotationBuilder<AnnotationType> parameter(String name, String value) {
        this.parameters.add((Pair<String, String>)Pair.of((Object)name, (Object)value));
        return this;
    }

    public JavaAnnotationBuilder<AnnotationType> parameter(Pair<String, String> parameter) {
        this.parameters.add(parameter);
        return this;
    }

    public JavaAnnotationBuilder<AnnotationType> parameters(List<Pair<String, String>> parameters) {
        this.parameters = parameters;
        return this;
    }

    private void checkForErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        if (StringUtil.isBlank((String)this.name)) {
            errors.add("Must specify name!");
        }
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException(StringUtil.buildStringWithNewLines(errors));
        }
    }

    public AnnotationType build() {
        this.checkForErrors();
        return this.constructAnnotation();
    }

    protected abstract AnnotationType constructAnnotation();
}

