/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.field;

import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.field.JavaField;
import com.github.tadukoo.java.javadoc.Javadoc;
import com.github.tadukoo.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class JavaFieldBuilder<FieldType extends JavaField> {
    protected Javadoc javadoc = null;
    protected List<JavaAnnotation> annotations = new ArrayList<JavaAnnotation>();
    protected Visibility visibility = Visibility.NONE;
    protected boolean isStatic = false;
    protected boolean isFinal = false;
    protected String type = null;
    protected String name = null;
    protected String value = null;

    protected JavaFieldBuilder() {
    }

    public JavaFieldBuilder<FieldType> copy(JavaField field) {
        this.javadoc = field.getJavadoc();
        this.annotations = field.getAnnotations();
        this.visibility = field.getVisibility();
        this.isStatic = field.isStatic();
        this.isFinal = field.isFinal();
        this.type = field.getType();
        this.name = field.getName();
        this.value = field.getValue();
        return this;
    }

    public JavaFieldBuilder<FieldType> javadoc(Javadoc javadoc) {
        this.javadoc = javadoc;
        return this;
    }

    public JavaFieldBuilder<FieldType> annotations(List<JavaAnnotation> annotations) {
        this.annotations = annotations;
        return this;
    }

    public JavaFieldBuilder<FieldType> annotation(JavaAnnotation annotation) {
        this.annotations.add(annotation);
        return this;
    }

    public JavaFieldBuilder<FieldType> visibility(Visibility visibility) {
        this.visibility = visibility;
        return this;
    }

    public JavaFieldBuilder<FieldType> isStatic() {
        this.isStatic = true;
        return this;
    }

    public JavaFieldBuilder<FieldType> isStatic(boolean isStatic) {
        this.isStatic = isStatic;
        return this;
    }

    public JavaFieldBuilder<FieldType> isFinal() {
        this.isFinal = true;
        return this;
    }

    public JavaFieldBuilder<FieldType> isFinal(boolean isFinal) {
        this.isFinal = isFinal;
        return this;
    }

    public JavaFieldBuilder<FieldType> type(String type) {
        this.type = type;
        return this;
    }

    public JavaFieldBuilder<FieldType> name(String name) {
        this.name = name;
        return this;
    }

    public JavaFieldBuilder<FieldType> value(String value) {
        this.value = value;
        return this;
    }

    private void checkForErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.visibility == null) {
            errors.add("Visibility is required!");
        }
        if (StringUtil.isBlank((String)this.type)) {
            errors.add("Must specify type!");
        }
        if (StringUtil.isBlank((String)this.name)) {
            errors.add("Must specify name!");
        }
        errors.addAll(this.checkForSpecificErrors());
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException(StringUtil.buildStringWithNewLines(errors));
        }
    }

    protected abstract List<String> checkForSpecificErrors();

    public FieldType build() {
        this.checkForErrors();
        return this.constructField();
    }

    protected abstract FieldType constructField();
}

