/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.importstatement;

import com.github.tadukoo.java.importstatement.JavaImportStatement;
import com.github.tadukoo.util.StringUtil;
import java.util.ArrayList;

public abstract class JavaImportStatementBuilder<ImportStatementType extends JavaImportStatement> {
    protected boolean isStatic = false;
    protected String importName = null;

    protected JavaImportStatementBuilder() {
    }

    public JavaImportStatementBuilder<ImportStatementType> copy(JavaImportStatement importStatement) {
        this.isStatic = importStatement.isStatic();
        this.importName = importStatement.getImportName();
        return this;
    }

    public JavaImportStatementBuilder<ImportStatementType> isStatic() {
        this.isStatic = true;
        return this;
    }

    public JavaImportStatementBuilder<ImportStatementType> isStatic(boolean isStatic) {
        this.isStatic = isStatic;
        return this;
    }

    public JavaImportStatementBuilder<ImportStatementType> importName(String importName) {
        this.importName = importName;
        return this;
    }

    private void checkForErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        if (StringUtil.isBlank((String)this.importName)) {
            errors.add("importName is required!");
        }
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException(StringUtil.buildStringWithNewLines(errors));
        }
    }

    public ImportStatementType build() {
        this.checkForErrors();
        return this.constructImportStatement();
    }

    protected abstract ImportStatementType constructImportStatement();
}

