/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.javaclass;

import com.github.tadukoo.java.JavaClassType;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.comment.JavaMultiLineComment;
import com.github.tadukoo.java.comment.JavaSingleLineComment;
import com.github.tadukoo.java.field.JavaField;
import com.github.tadukoo.java.importstatement.JavaImportStatement;
import com.github.tadukoo.java.javadoc.Javadoc;
import com.github.tadukoo.java.method.JavaMethod;
import com.github.tadukoo.java.packagedeclaration.JavaPackageDeclaration;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.map.HashMultiMap;
import com.github.tadukoo.util.map.MultiMap;
import com.github.tadukoo.util.tuple.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class JavaClass
implements JavaClassType {
    private final boolean editable;
    protected boolean isInnerClass;
    protected JavaPackageDeclaration packageDeclaration;
    protected List<JavaImportStatement> importStatements;
    protected Javadoc javadoc;
    protected List<JavaAnnotation> annotations;
    protected Visibility visibility;
    protected boolean isAbstract;
    protected boolean isStatic;
    protected boolean isFinal;
    protected String className;
    protected String superClassName;
    protected List<String> implementsInterfaceNames;
    protected List<JavaSingleLineComment> singleLineComments;
    protected List<JavaMultiLineComment> multiLineComments;
    protected List<JavaClass> innerClasses;
    protected List<JavaField> fields;
    protected List<JavaMethod> methods;
    protected List<Pair<JavaCodeTypes, String>> innerElementsOrder;

    protected JavaClass(boolean editable, boolean isInnerClass, JavaPackageDeclaration packageDeclaration, List<JavaImportStatement> importStatements, Javadoc javadoc, List<JavaAnnotation> annotations, Visibility visibility, boolean isAbstract, boolean isStatic, boolean isFinal, String className, String superClassName, List<String> implementsInterfaceNames, List<JavaSingleLineComment> singleLineComments, List<JavaMultiLineComment> multiLineComments, List<JavaClass> innerClasses, List<JavaField> fields, List<JavaMethod> methods, List<Pair<JavaCodeTypes, String>> innerElementsOrder) {
        this.editable = editable;
        this.isInnerClass = isInnerClass;
        this.packageDeclaration = packageDeclaration;
        this.importStatements = importStatements;
        this.javadoc = javadoc;
        this.annotations = annotations;
        this.visibility = visibility;
        this.isAbstract = isAbstract;
        this.isStatic = isStatic;
        this.isFinal = isFinal;
        this.className = className;
        this.superClassName = superClassName;
        this.implementsInterfaceNames = implementsInterfaceNames;
        this.singleLineComments = singleLineComments;
        this.multiLineComments = multiLineComments;
        this.innerClasses = innerClasses;
        this.fields = fields;
        this.methods = methods;
        this.innerElementsOrder = innerElementsOrder;
    }

    @Override
    public JavaCodeTypes getJavaCodeType() {
        return JavaCodeTypes.CLASS;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isInnerClass() {
        return this.isInnerClass;
    }

    public JavaPackageDeclaration getPackageDeclaration() {
        return this.packageDeclaration;
    }

    public List<JavaImportStatement> getImportStatements() {
        return this.importStatements;
    }

    public Javadoc getJavadoc() {
        return this.javadoc;
    }

    public List<JavaAnnotation> getAnnotations() {
        return this.annotations;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public String getClassName() {
        return this.className;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public List<String> getImplementsInterfaceNames() {
        return this.implementsInterfaceNames;
    }

    public List<JavaSingleLineComment> getSingleLineComments() {
        return this.singleLineComments;
    }

    public List<JavaMultiLineComment> getMultiLineComments() {
        return this.multiLineComments;
    }

    public List<JavaClass> getInnerClasses() {
        return this.innerClasses;
    }

    public Map<String, JavaClass> getInnerClassesMap() {
        HashMap<String, JavaClass> classMap = new HashMap<String, JavaClass>();
        for (JavaClass clazz : this.innerClasses) {
            classMap.put(clazz.getClassName(), clazz);
        }
        return classMap;
    }

    public List<JavaField> getFields() {
        return this.fields;
    }

    public Map<String, JavaField> getFieldsMap() {
        HashMap<String, JavaField> fieldMap = new HashMap<String, JavaField>();
        for (JavaField field : this.fields) {
            fieldMap.put(field.getName(), field);
        }
        return fieldMap;
    }

    public List<JavaMethod> getMethods() {
        return this.methods;
    }

    public Map<String, JavaMethod> getMethodsMap() {
        HashMap<String, JavaMethod> methodMap = new HashMap<String, JavaMethod>();
        for (JavaMethod method : this.methods) {
            methodMap.put(method.getUniqueName(), method);
        }
        return methodMap;
    }

    public List<Pair<JavaCodeTypes, String>> getInnerElementsOrder() {
        return this.innerElementsOrder;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        StringBuilder declaration;
        ArrayList<String> content = new ArrayList<String>();
        if (this.packageDeclaration != null) {
            content.add(this.packageDeclaration.toString());
            content.add("");
        }
        if (ListUtil.isNotBlank(this.importStatements)) {
            List<String> alphabetizedImports;
            List alphabetizedKeys;
            MultiMap<String, JavaImportStatement> sortedImports;
            ArrayList regularImports = new ArrayList();
            ArrayList<JavaImportStatement> arrayList = new ArrayList<JavaImportStatement>();
            this.importStatements.forEach(stmt -> {
                if (stmt.isStatic()) {
                    staticImports.add((JavaImportStatement)stmt);
                } else {
                    regularImports.add(stmt);
                }
            });
            if (ListUtil.isNotBlank((List)regularImports)) {
                sortedImports = this.sortImports(regularImports);
                alphabetizedKeys = sortedImports.keySet().stream().sorted().toList();
                for (String key : alphabetizedKeys) {
                    alphabetizedImports = sortedImports.get((Object)key).stream().map(JavaImportStatement::toString).sorted().toList();
                    content.addAll(alphabetizedImports);
                    content.add("");
                }
            }
            if (ListUtil.isNotBlank(arrayList)) {
                sortedImports = this.sortImports(arrayList);
                alphabetizedKeys = sortedImports.keySet().stream().sorted().toList();
                for (String key : alphabetizedKeys) {
                    alphabetizedImports = sortedImports.get((Object)key).stream().map(JavaImportStatement::toString).sorted().toList();
                    content.addAll(alphabetizedImports);
                    content.add("");
                }
            }
        }
        if (this.javadoc != null) {
            content.add(this.javadoc.toString());
        }
        if (ListUtil.isNotBlank(this.annotations)) {
            for (JavaAnnotation javaAnnotation : this.annotations) {
                content.add(javaAnnotation.toString());
            }
        }
        if (!(declaration = new StringBuilder(this.visibility.getToken())).isEmpty()) {
            declaration.append(' ');
        }
        if (this.isAbstract) {
            declaration.append("abstract").append(' ');
        }
        if (this.isStatic) {
            declaration.append("static").append(' ');
        }
        if (this.isFinal) {
            declaration.append("final").append(' ');
        }
        declaration.append("class").append(' ').append(this.className);
        if (StringUtil.isNotBlank((String)this.superClassName)) {
            declaration.append(' ').append("extends").append(' ').append(this.superClassName);
        }
        if (ListUtil.isNotBlank(this.implementsInterfaceNames)) {
            declaration.append(' ').append("implements");
            for (String implementsInterfaceName : this.implementsInterfaceNames) {
                declaration.append(' ').append(implementsInterfaceName).append(',');
            }
            declaration.deleteCharAt(declaration.length() - 1);
        }
        declaration.append("{");
        content.add(declaration.toString());
        content.add("\t");
        if (ListUtil.isNotBlank(this.innerElementsOrder)) {
            boolean bl = false;
            int multiLineCommentIndex = 0;
            Map<String, JavaClass> innerClassesByName = this.getInnerClassesMap();
            Map<String, JavaField> fieldsByName = this.getFieldsMap();
            Map<String, JavaMethod> methodsByName = this.getMethodsMap();
            JavaCodeTypes lastType = null;
            for (Pair<JavaCodeTypes, String> elementInfo : this.innerElementsOrder) {
                switch ((JavaCodeTypes)((Object)elementInfo.getLeft())) {
                    case SINGLE_LINE_COMMENT: {
                        void var3_9;
                        content.add(StringUtil.indentAllLines((String)this.singleLineComments.get((int)var3_9).toString()));
                        ++var3_9;
                        break;
                    }
                    case MULTI_LINE_COMMENT: {
                        content.add(StringUtil.indentAllLines((String)this.multiLineComments.get(multiLineCommentIndex).toString()));
                        content.add("\t");
                        ++multiLineCommentIndex;
                        break;
                    }
                    case CLASS: {
                        content.add(StringUtil.indentAllLines((String)innerClassesByName.get(elementInfo.getRight()).toString()));
                        break;
                    }
                    case FIELD: {
                        content.add(StringUtil.indentAllLines((String)fieldsByName.get(elementInfo.getRight()).toString()));
                        break;
                    }
                    case METHOD: {
                        if (lastType == JavaCodeTypes.FIELD) {
                            content.add("\t");
                        }
                        content.add(StringUtil.indentAllLines((String)methodsByName.get(elementInfo.getRight()).toString()));
                        content.add("\t");
                    }
                }
                lastType = (JavaCodeTypes)((Object)elementInfo.getLeft());
            }
            if (StringUtil.equals((String)((String)content.get(content.size() - 1)), (String)"\t")) {
                content.remove(content.size() - 1);
            }
        } else {
            if (ListUtil.isNotBlank(this.innerClasses)) {
                for (JavaClass clazz : this.innerClasses) {
                    content.add(StringUtil.indentAllLines((String)clazz.toString()));
                }
            }
            if (ListUtil.isNotBlank(this.fields)) {
                for (JavaField field : this.fields) {
                    content.add(StringUtil.indentAllLines((String)field.toString()));
                }
            }
            if (ListUtil.isNotBlank(this.methods)) {
                if (ListUtil.isNotBlank(this.fields)) {
                    content.add("\t");
                }
                for (JavaMethod method : this.methods) {
                    content.add(StringUtil.indentAllLines((String)method.toString()));
                    content.add("\t");
                }
                content.remove(content.size() - 1);
            }
        }
        content.add("}");
        content.add("");
        return StringUtil.buildStringWithNewLines(content);
    }

    private MultiMap<String, JavaImportStatement> sortImports(List<JavaImportStatement> importStatements) {
        HashMultiMap mappedStatements = new HashMultiMap();
        for (JavaImportStatement importStatement : importStatements) {
            String start = importStatement.getImportName().split("\\.")[0];
            mappedStatements.put((Object)start, (Object)importStatement);
        }
        return mappedStatements;
    }

    public boolean equals(Object otherClass) {
        if (otherClass instanceof JavaClass) {
            JavaClass clazz = (JavaClass)otherClass;
            return StringUtil.equals((String)this.toString(), (String)clazz.toString());
        }
        return false;
    }

    @Override
    public String toBuilderCode() {
        StringBuilder codeString = new StringBuilder(this.getClass().getSimpleName()).append(".builder()");
        if (this.isInnerClass) {
            codeString.append("\n\t\t").append(".innerClass()");
        }
        if (this.packageDeclaration != null) {
            codeString.append("\n\t\t").append(".packageName(\"").append(this.packageDeclaration.getPackageName()).append("\")");
        }
        if (ListUtil.isNotBlank(this.importStatements)) {
            for (JavaImportStatement importStatement : this.importStatements) {
                codeString.append("\n\t\t").append(".importName(\"").append(importStatement.getImportName()).append("\", ").append(importStatement.isStatic()).append(')');
            }
        }
        if (this.javadoc != null) {
            codeString.append("\n\t\t").append(".javadoc(").append(this.javadoc.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t")).append(')');
        }
        if (ListUtil.isNotBlank(this.annotations)) {
            for (JavaAnnotation annotation : this.annotations) {
                codeString.append("\n\t\t").append(".annotation(").append(annotation.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t")).append(')');
            }
        }
        if (this.visibility != Visibility.NONE) {
            codeString.append("\n\t\t").append(".visibility(Visibility.").append(this.visibility).append(')');
        }
        if (this.isAbstract) {
            codeString.append("\n\t\t").append(".isAbstract()");
        }
        if (this.isStatic) {
            codeString.append("\n\t\t").append(".isStatic()");
        }
        if (this.isFinal) {
            codeString.append("\n\t\t").append(".isFinal()");
        }
        codeString.append("\n\t\t").append(".className(\"").append(this.className).append("\")");
        if (StringUtil.isNotBlank((String)this.superClassName)) {
            codeString.append("\n\t\t").append(".superClassName(\"").append(this.superClassName).append("\")");
        }
        if (ListUtil.isNotBlank(this.implementsInterfaceNames)) {
            for (String interfaceName : this.implementsInterfaceNames) {
                codeString.append("\n\t\t").append(".implementsInterfaceName(\"").append(interfaceName).append("\")");
            }
        }
        if (ListUtil.isNotBlank(this.innerElementsOrder)) {
            int singleLineCommentIndex = 0;
            int multiLineCommentIndex = 0;
            Map<String, JavaClass> innerClassesMap = this.getInnerClassesMap();
            Map<String, JavaField> fieldsMap = this.getFieldsMap();
            Map<String, JavaMethod> methodsMap = this.getMethodsMap();
            for (Pair<JavaCodeTypes, String> innerElementInfo : this.innerElementsOrder) {
                switch ((JavaCodeTypes)((Object)innerElementInfo.getLeft())) {
                    case SINGLE_LINE_COMMENT: {
                        codeString.append("\n\t\t").append(".singleLineComment(").append(this.singleLineComments.get(singleLineCommentIndex).toBuilderCode().replace("\n\t\t", "\n\t\t\t\t")).append(')');
                        ++singleLineCommentIndex;
                        break;
                    }
                    case MULTI_LINE_COMMENT: {
                        codeString.append("\n\t\t").append(".multiLineComment(").append(this.multiLineComments.get(multiLineCommentIndex).toBuilderCode().replace("\n\t\t", "\n\t\t\t\t")).append(')');
                        ++multiLineCommentIndex;
                        break;
                    }
                    case CLASS: {
                        codeString.append("\n\t\t").append(".innerClass(").append(innerClassesMap.get(innerElementInfo.getRight()).toBuilderCode().replace("\n\t\t", "\n\t\t\t\t")).append(')');
                        break;
                    }
                    case FIELD: {
                        codeString.append("\n\t\t").append(".field(").append(fieldsMap.get(innerElementInfo.getRight()).toBuilderCode().replace("\n\t\t", "\n\t\t\t\t")).append(')');
                        break;
                    }
                    case METHOD: {
                        codeString.append("\n\t\t").append(".method(").append(methodsMap.get(innerElementInfo.getRight()).toBuilderCode().replace("\n\t\t", "\n\t\t\t\t")).append(')');
                    }
                }
            }
        } else {
            if (ListUtil.isNotBlank(this.innerClasses)) {
                for (JavaClass innerClass : this.innerClasses) {
                    codeString.append("\n\t\t").append(".innerClass(").append(innerClass.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t")).append(')');
                }
            }
            if (ListUtil.isNotBlank(this.fields)) {
                for (JavaField field : this.fields) {
                    codeString.append("\n\t\t").append(".field(").append(field.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t")).append(')');
                }
            }
            if (ListUtil.isNotBlank(this.methods)) {
                for (JavaMethod method : this.methods) {
                    codeString.append("\n\t\t").append(".method(").append(method.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t")).append(')');
                }
            }
        }
        codeString.append("\n\t\t").append(".build()");
        return codeString.toString();
    }
}

