/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.javadoc;

import com.github.tadukoo.java.JavaCodeType;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.tuple.Pair;
import java.util.List;

public abstract class Javadoc
implements JavaCodeType {
    private final boolean editable;
    protected boolean condensed;
    protected List<String> content;
    protected String author;
    protected String version;
    protected String since;
    protected List<Pair<String, String>> params;
    protected String returnVal;
    protected List<Pair<String, String>> throwsInfos;

    protected Javadoc(boolean editable, boolean condensed, List<String> content, String author, String version, String since, List<Pair<String, String>> params, String returnVal, List<Pair<String, String>> throwsInfos) {
        this.editable = editable;
        this.condensed = condensed;
        this.content = content;
        this.author = author;
        this.version = version;
        this.since = since;
        this.params = params;
        this.returnVal = returnVal;
        this.throwsInfos = throwsInfos;
    }

    @Override
    public JavaCodeTypes getJavaCodeType() {
        return JavaCodeTypes.JAVADOC;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isCondensed() {
        return this.condensed;
    }

    public List<String> getContent() {
        return this.content;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSince() {
        return this.since;
    }

    public List<Pair<String, String>> getParams() {
        return this.params;
    }

    public String getReturnVal() {
        return this.returnVal;
    }

    public List<Pair<String, String>> getThrowsInfos() {
        return this.throwsInfos;
    }

    public String toString() {
        StringBuilder doc = new StringBuilder("/**");
        boolean haveContent = ListUtil.isNotBlank(this.content);
        boolean haveInfoAnnotations = StringUtil.anyNotBlank((String[])new String[]{this.author, this.version, this.since});
        boolean haveCodeAnnotations = ListUtil.isNotBlank(this.params) || StringUtil.isNotBlank((String)this.returnVal) || ListUtil.isNotBlank(this.throwsInfos);
        boolean prevContent = false;
        if (!this.condensed && (haveContent || haveInfoAnnotations || haveCodeAnnotations)) {
            doc.append("\n ").append("*");
        }
        if (haveContent) {
            for (String string : this.content) {
                doc.append(" ").append(string).append("\n ").append("*");
            }
            if (!haveInfoAnnotations && !haveCodeAnnotations) {
                doc.delete(doc.length() - 3, doc.length());
            } else {
                doc.append(" ");
            }
            prevContent = true;
        }
        if (StringUtil.isNotBlank((String)this.author)) {
            if (prevContent) {
                doc.append("\n ").append("*");
            }
            doc.append(' ').append("@").append("author").append(' ').append(this.author);
            prevContent = true;
        }
        if (StringUtil.isNotBlank((String)this.version)) {
            if (prevContent) {
                doc.append("\n ").append("*");
            }
            doc.append(' ').append("@").append("version").append(' ').append(this.version);
            prevContent = true;
        }
        if (StringUtil.isNotBlank((String)this.since)) {
            if (prevContent) {
                doc.append("\n ").append("*");
            }
            doc.append(' ').append("@").append("since").append(' ').append(this.since);
            prevContent = true;
        }
        if (haveInfoAnnotations && haveCodeAnnotations) {
            doc.append("\n ").append("*").append(' ');
        }
        if (ListUtil.isNotBlank(this.params)) {
            if (prevContent) {
                doc.append("\n ").append("*");
            }
            for (Pair pair : this.params) {
                doc.append(' ').append("@").append("param").append(' ').append((String)pair.getLeft()).append(' ').append((String)pair.getRight()).append("\n ").append("*");
            }
            doc.delete(doc.length() - 3, doc.length());
            prevContent = true;
        }
        if (StringUtil.isNotBlank((String)this.returnVal)) {
            if (prevContent) {
                doc.append("\n ").append("*");
            }
            doc.append(' ').append("@").append("return").append(' ').append(this.returnVal);
            prevContent = true;
        }
        if (ListUtil.isNotBlank(this.throwsInfos)) {
            if (prevContent) {
                doc.append("\n ").append("*");
            }
            for (Pair pair : this.throwsInfos) {
                doc.append(' ').append("@").append("throws").append(' ').append((String)pair.getLeft()).append(' ').append((String)pair.getRight()).append("\n ").append("*");
            }
            doc.delete(doc.length() - 3, doc.length());
        }
        if (!this.condensed) {
            doc.append("\n");
        }
        doc.append(' ').append("*/");
        return doc.toString();
    }

    public boolean equals(Object otherJavadoc) {
        if (otherJavadoc instanceof Javadoc) {
            Javadoc doc = (Javadoc)otherJavadoc;
            return StringUtil.equals((String)this.toString(), (String)doc.toString());
        }
        return false;
    }

    @Override
    public String toBuilderCode() {
        StringBuilder codeString = new StringBuilder(this.getClass().getSimpleName()).append(".builder()");
        if (this.condensed) {
            codeString.append("\n\t\t").append(".condensed()");
        }
        if (ListUtil.isNotBlank(this.content)) {
            for (String string : this.content) {
                codeString.append("\n\t\t").append(".content(\"").append(this.escapeQuotes(string)).append("\")");
            }
        }
        if (StringUtil.isNotBlank((String)this.author)) {
            codeString.append("\n\t\t").append(".author(\"").append(this.escapeQuotes(this.author)).append("\")");
        }
        if (StringUtil.isNotBlank((String)this.version)) {
            codeString.append("\n\t\t").append(".version(\"").append(this.escapeQuotes(this.version)).append("\")");
        }
        if (StringUtil.isNotBlank((String)this.since)) {
            codeString.append("\n\t\t").append(".since(\"").append(this.escapeQuotes(this.since)).append("\")");
        }
        if (ListUtil.isNotBlank(this.params)) {
            for (Pair pair : this.params) {
                codeString.append("\n\t\t").append(".param(\"").append(this.escapeQuotes((String)pair.getLeft())).append("\", \"").append(this.escapeQuotes((String)pair.getRight())).append("\")");
            }
        }
        if (StringUtil.isNotBlank((String)this.returnVal)) {
            codeString.append("\n\t\t").append(".returnVal(\"").append(this.escapeQuotes(this.returnVal)).append("\")");
        }
        if (ListUtil.isNotBlank(this.throwsInfos)) {
            for (Pair pair : this.throwsInfos) {
                codeString.append("\n\t\t").append(".throwsInfo(\"").append(this.escapeQuotes((String)pair.getLeft())).append("\", \"").append(this.escapeQuotes((String)pair.getRight())).append("\")");
            }
        }
        codeString.append("\n\t\t").append(".build()");
        return codeString.toString();
    }
}

