/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.javadoc;

import com.github.tadukoo.java.javadoc.Javadoc;
import com.github.tadukoo.util.tuple.Pair;
import java.util.ArrayList;
import java.util.List;

public abstract class JavadocBuilder<JavadocType extends Javadoc> {
    protected boolean condensed = false;
    protected List<String> content = new ArrayList<String>();
    protected String author = null;
    protected String version = null;
    protected String since = null;
    protected List<Pair<String, String>> params = new ArrayList<Pair<String, String>>();
    protected String returnVal = null;
    protected List<Pair<String, String>> throwsInfos = new ArrayList<Pair<String, String>>();

    protected JavadocBuilder() {
    }

    public JavadocBuilder<JavadocType> copy(Javadoc javadoc) {
        this.condensed = javadoc.isCondensed();
        this.content = javadoc.getContent();
        this.author = javadoc.getAuthor();
        this.version = javadoc.getVersion();
        this.since = javadoc.getSince();
        this.params = javadoc.getParams();
        this.returnVal = javadoc.getReturnVal();
        this.throwsInfos = javadoc.getThrowsInfos();
        return this;
    }

    public JavadocBuilder<JavadocType> condensed(boolean condensed) {
        this.condensed = condensed;
        return this;
    }

    public JavadocBuilder<JavadocType> condensed() {
        this.condensed = true;
        return this;
    }

    public JavadocBuilder<JavadocType> content(List<String> content) {
        this.content = content;
        return this;
    }

    public JavadocBuilder<JavadocType> content(String content) {
        this.content.add(content);
        return this;
    }

    public JavadocBuilder<JavadocType> author(String author) {
        this.author = author;
        return this;
    }

    public JavadocBuilder<JavadocType> version(String version) {
        this.version = version;
        return this;
    }

    public JavadocBuilder<JavadocType> since(String since) {
        this.since = since;
        return this;
    }

    public JavadocBuilder<JavadocType> params(List<Pair<String, String>> params) {
        this.params = params;
        return this;
    }

    public JavadocBuilder<JavadocType> param(Pair<String, String> param) {
        this.params.add(param);
        return this;
    }

    public JavadocBuilder<JavadocType> param(String name, String description) {
        this.params.add((Pair<String, String>)Pair.of((Object)name, (Object)description));
        return this;
    }

    public JavadocBuilder<JavadocType> returnVal(String returnVal) {
        this.returnVal = returnVal;
        return this;
    }

    public JavadocBuilder<JavadocType> throwsInfos(List<Pair<String, String>> throwsInfos) {
        this.throwsInfos = throwsInfos;
        return this;
    }

    public JavadocBuilder<JavadocType> throwsInfo(Pair<String, String> throwsInfo) {
        this.throwsInfos.add(throwsInfo);
        return this;
    }

    public JavadocBuilder<JavadocType> throwsInfo(String throwable, String explanation) {
        this.throwsInfos.add((Pair<String, String>)Pair.of((Object)throwable, (Object)explanation));
        return this;
    }

    public JavadocType build() {
        return this.constructJavadoc();
    }

    protected abstract JavadocType constructJavadoc();
}

