/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.method;

import com.github.tadukoo.java.JavaCodeType;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.javadoc.Javadoc;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.tuple.Pair;
import java.util.ArrayList;
import java.util.List;

public abstract class JavaMethod
implements JavaCodeType {
    private final boolean editable;
    protected Javadoc javadoc;
    protected List<JavaAnnotation> annotations;
    protected Visibility visibility;
    protected boolean isAbstract;
    protected boolean isStatic;
    protected boolean isFinal;
    protected String returnType;
    protected String name;
    protected List<Pair<String, String>> parameters;
    protected List<String> throwTypes;
    protected List<String> lines;

    protected JavaMethod(boolean editable, Javadoc javadoc, List<JavaAnnotation> annotations, Visibility visibility, boolean isAbstract, boolean isStatic, boolean isFinal, String returnType, String name, List<Pair<String, String>> parameters, List<String> throwTypes, List<String> lines) {
        this.editable = editable;
        this.javadoc = javadoc;
        this.annotations = annotations;
        this.visibility = visibility;
        this.isAbstract = isAbstract;
        this.isStatic = isStatic;
        this.isFinal = isFinal;
        this.returnType = returnType;
        this.name = name;
        this.parameters = parameters;
        this.throwTypes = throwTypes;
        this.lines = lines;
    }

    @Override
    public JavaCodeTypes getJavaCodeType() {
        return JavaCodeTypes.METHOD;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public Javadoc getJavadoc() {
        return this.javadoc;
    }

    public List<JavaAnnotation> getAnnotations() {
        return this.annotations;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getName() {
        return this.name;
    }

    public String getUniqueName() {
        StringBuilder fullName = new StringBuilder(StringUtil.isNotBlank((String)this.name) ? this.name : "init").append('(');
        if (ListUtil.isNotBlank(this.parameters)) {
            for (Pair<String, String> parameter : this.parameters) {
                fullName.append((String)parameter.getLeft()).append(' ').append((String)parameter.getRight()).append(", ");
            }
            fullName.delete(fullName.length() - 2, fullName.length());
        }
        fullName.append(')');
        return fullName.toString();
    }

    public List<Pair<String, String>> getParameters() {
        return this.parameters;
    }

    public List<String> getThrowTypes() {
        return this.throwTypes;
    }

    public List<String> getLines() {
        return this.lines;
    }

    public String toString() {
        StringBuilder declaration;
        ArrayList<Object> content = new ArrayList<Object>();
        if (this.javadoc != null) {
            content.add(this.javadoc.toString());
        }
        if (ListUtil.isNotBlank(this.annotations)) {
            for (JavaAnnotation annotation : this.annotations) {
                content.add(annotation.toString());
            }
        }
        if (!(declaration = new StringBuilder(this.visibility.getToken())).isEmpty()) {
            declaration.append(' ');
        }
        if (this.isAbstract) {
            declaration.append("abstract").append(' ');
        }
        if (this.isStatic) {
            declaration.append("static").append(' ');
        }
        if (this.isFinal) {
            declaration.append("final").append(' ');
        }
        declaration.append(this.returnType);
        if (StringUtil.isNotBlank((String)this.name)) {
            declaration.append(' ').append(this.name);
        }
        declaration.append("(");
        boolean multiline = false;
        if (ListUtil.isNotBlank(this.parameters)) {
            for (Pair<String, String> parameter : this.parameters) {
                int parameterLength = ((String)parameter.getLeft()).length() + ((String)parameter.getRight()).length() + 1;
                if (declaration.length() + parameterLength > 110) {
                    if (!multiline) {
                        int cutoff = declaration.indexOf("(") + 1;
                        content.add(declaration.substring(0, cutoff));
                        declaration.delete(0, cutoff);
                        declaration.insert(0, "\t\t");
                        if (declaration.length() > 2 && declaration.length() + parameterLength > 110) {
                            content.add(declaration.toString());
                            declaration = new StringBuilder("\t\t");
                        }
                        multiline = true;
                    } else {
                        content.add(declaration.toString());
                        declaration = new StringBuilder("\t\t");
                    }
                }
                declaration.append((String)parameter.getLeft()).append(' ').append((String)parameter.getRight()).append(",").append(' ');
            }
            declaration.setLength(declaration.length() - 2);
        }
        if (ListUtil.isNotBlank(this.throwTypes)) {
            declaration.append(")").append(' ').append("throws").append(' ');
            for (String throwType : this.throwTypes) {
                declaration.append(throwType).append(",").append(' ');
            }
            declaration.delete(declaration.length() - 2, declaration.length());
        } else {
            declaration.append(")");
        }
        if (this.isAbstract) {
            declaration.append(";");
            content.add(declaration.toString());
        } else {
            declaration.append("{");
            if (ListUtil.isNotBlank(this.lines)) {
                content.add(declaration.toString());
                for (String line : this.lines) {
                    content.add("\t" + line);
                }
                content.add("}");
            } else {
                declaration.append(' ').append("}");
                content.add(declaration.toString());
            }
        }
        return StringUtil.buildStringWithNewLines(content);
    }

    public boolean equals(Object otherMethod) {
        if (otherMethod instanceof JavaMethod) {
            JavaMethod method = (JavaMethod)otherMethod;
            return StringUtil.equals((String)this.toString(), (String)method.toString());
        }
        return false;
    }

    @Override
    public String toBuilderCode() {
        StringBuilder codeString = new StringBuilder(this.getClass().getSimpleName()).append(".builder()");
        if (this.javadoc != null) {
            codeString.append("\n\t\t").append(".javadoc(").append(this.javadoc.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t")).append(')');
        }
        if (ListUtil.isNotBlank(this.annotations)) {
            for (JavaAnnotation javaAnnotation : this.annotations) {
                codeString.append("\n\t\t").append(".annotation(").append(javaAnnotation.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t")).append(')');
            }
        }
        if (this.visibility != Visibility.NONE) {
            codeString.append("\n\t\t").append(".visibility(Visibility.").append(this.visibility).append(')');
        }
        if (this.isAbstract) {
            codeString.append("\n\t\t").append(".isAbstract()");
        }
        if (this.isStatic) {
            codeString.append("\n\t\t").append(".isStatic()");
        }
        if (this.isFinal) {
            codeString.append("\n\t\t").append(".isFinal()");
        }
        codeString.append("\n\t\t").append(".returnType(\"").append(this.returnType).append("\")");
        if (StringUtil.isNotBlank((String)this.name)) {
            codeString.append("\n\t\t").append(".name(\"").append(this.name).append("\")");
        }
        if (ListUtil.isNotBlank(this.parameters)) {
            for (Pair pair : this.parameters) {
                codeString.append("\n\t\t").append(".parameter(\"").append((String)pair.getLeft()).append("\", \"").append((String)pair.getRight()).append("\")");
            }
        }
        if (ListUtil.isNotBlank(this.throwTypes)) {
            for (String string : this.throwTypes) {
                codeString.append("\n\t\t").append(".throwType(\"").append(string).append("\")");
            }
        }
        if (ListUtil.isNotBlank(this.lines)) {
            for (String string : this.lines) {
                codeString.append("\n\t\t").append(".line(\"").append(this.escapeQuotes(string)).append("\")");
            }
        }
        codeString.append("\n\t\t").append(".build()");
        return codeString.toString();
    }
}

