/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.packagedeclaration;

import com.github.tadukoo.java.packagedeclaration.JavaPackageDeclaration;
import com.github.tadukoo.util.StringUtil;
import java.util.ArrayList;

public abstract class JavaPackageDeclarationBuilder<PackageDeclaration extends JavaPackageDeclaration> {
    protected String packageName = null;

    protected JavaPackageDeclarationBuilder() {
    }

    public JavaPackageDeclarationBuilder<PackageDeclaration> copy(JavaPackageDeclaration packageDeclaration) {
        this.packageName = packageDeclaration.getPackageName();
        return this;
    }

    public JavaPackageDeclarationBuilder<PackageDeclaration> packageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    private void checkForErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        if (StringUtil.isBlank((String)this.packageName)) {
            errors.add("packageName is required!");
        }
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException(StringUtil.buildStringWithNewLines(errors));
        }
    }

    public PackageDeclaration build() {
        this.checkForErrors();
        return this.constructPackageDeclaration();
    }

    protected abstract PackageDeclaration constructPackageDeclaration();
}

