/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.JavaTokens;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.java.parsing.ParsingPojo;
import com.github.tadukoo.util.StringUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractJavaParser
implements JavaTokens {
    private static final String SINGLE_MODIFIER_REGEX = "(?:(public|protected|private|static|final|abstract)\\s*)?";
    protected static final String MODIFIERS_REGEX = "(?:(public|protected|private|static|final|abstract)\\s*)?(?:(public|protected|private|static|final|abstract)\\s*)?(?:(public|protected|private|static|final|abstract)\\s*)?";
    protected static final String TOKEN_REGEX = "\n|\\(|\\)|\\{|}|=|[^\\S\n]+|[^\\s(){}=]+";
    protected static final Matcher WHITESPACE_MATCHER = Pattern.compile("\\s+").matcher("");

    protected AbstractJavaParser() {
    }

    protected static List<String> splitContentIntoTokens(String content) {
        return StringUtil.parseListFromStringWithPattern((String)content, (String)TOKEN_REGEX, (boolean)false).stream().filter(StringUtil::isNotBlank).toList();
    }

    protected static int skipLeadingWhitespace(List<String> tokens) {
        int startToken = 0;
        while (WHITESPACE_MATCHER.reset(tokens.get(startToken)).matches()) {
            ++startToken;
        }
        return startToken;
    }

    protected static void verifyEndOfTokens(List<String> tokens, ParsingPojo result, JavaCodeTypes type) throws JavaParsingException {
        if (result.nextTokenIndex() != tokens.size()) {
            int lastTokenIndex;
            for (lastTokenIndex = result.nextTokenIndex(); lastTokenIndex < tokens.size() && WHITESPACE_MATCHER.reset(tokens.get(lastTokenIndex)).matches(); ++lastTokenIndex) {
            }
            if (lastTokenIndex != tokens.size()) {
                throw new JavaParsingException(type, "Found extra content after the " + type.getStandardName() + "!");
            }
        }
    }

    protected static JavaCodeTypes determineFieldOrMethod(List<String> tokens, int currentToken) {
        int thisToken;
        for (thisToken = currentToken + 1; thisToken < tokens.size() && WHITESPACE_MATCHER.reset(tokens.get(thisToken)).matches(); ++thisToken) {
        }
        if (thisToken >= tokens.size()) {
            return JavaCodeTypes.UNKNOWN;
        }
        String token = tokens.get(thisToken);
        if (StringUtil.equals((String)token, (String)"(")) {
            return JavaCodeTypes.METHOD;
        }
        if (token.endsWith(";")) {
            return JavaCodeTypes.FIELD;
        }
        ++thisToken;
        while (thisToken < tokens.size() && WHITESPACE_MATCHER.reset(tokens.get(thisToken)).matches()) {
            ++thisToken;
        }
        if (thisToken >= tokens.size()) {
            return JavaCodeTypes.UNKNOWN;
        }
        token = tokens.get(thisToken);
        if (StringUtil.equals((String)token, (String)"(")) {
            return JavaCodeTypes.METHOD;
        }
        if (StringUtil.equalsAny((String)token, (String[])new String[]{"=", ";"})) {
            return JavaCodeTypes.FIELD;
        }
        return JavaCodeTypes.UNKNOWN;
    }
}

