/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.codetypes;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.annotation.EditableJavaAnnotation;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.parsing.AbstractJavaParser;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.java.parsing.ParsingPojo;
import com.github.tadukoo.util.StringUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaAnnotationParser
extends AbstractJavaParser {
    private static final Pattern ANNOTATION_PATTERN = Pattern.compile("\\s*@\\s*([^\\s(]*)(?:\\s*\\((.*)\\)\\s*)?\\s*", 32);
    private static final Pattern ANNOTATION_PARAMETER_PATTERN = Pattern.compile("\\s*([^=,]*)\\s*=\\s*([^,]*),?\\s*");

    private JavaAnnotationParser() {
    }

    public static ParsingPojo parseAnnotation(List<String> tokens, int startToken) throws JavaParsingException {
        int currentToken;
        if (!tokens.get(startToken).startsWith("@")) {
            throw new JavaParsingException(JavaCodeTypes.ANNOTATION, "First token of annotation must start with '@'");
        }
        String firstToken = tokens.get(startToken);
        StringBuilder fullAnnotation = new StringBuilder(firstToken);
        for (currentToken = startToken + 1; currentToken < tokens.size() && WHITESPACE_MATCHER.reset(tokens.get(currentToken)).matches(); ++currentToken) {
        }
        if (StringUtil.equals((String)firstToken, (String)"@")) {
            String nextToken = tokens.get(currentToken);
            fullAnnotation.append(nextToken);
            ++currentToken;
        }
        while (currentToken < tokens.size() && WHITESPACE_MATCHER.reset(tokens.get(currentToken)).matches()) {
            ++currentToken;
        }
        boolean parametersOpen = false;
        boolean parametersDone = false;
        if (currentToken < tokens.size() && StringUtil.equals((String)tokens.get(currentToken), (String)"(")) {
            fullAnnotation.append("(");
            parametersOpen = true;
            ++currentToken;
        }
        while (parametersOpen && !parametersDone && currentToken < tokens.size()) {
            String token = tokens.get(currentToken);
            fullAnnotation.append(token);
            if (StringUtil.equals((String)token, (String)")")) {
                parametersDone = true;
            }
            ++currentToken;
        }
        if (parametersOpen && !parametersDone) {
            throw new JavaParsingException(JavaCodeTypes.ANNOTATION, "Didn't find end of parameters");
        }
        JavaAnnotation annotation = JavaAnnotationParser.parseAnnotation(fullAnnotation.toString());
        return new ParsingPojo(currentToken, annotation);
    }

    public static JavaAnnotation parseAnnotation(String content) throws JavaParsingException {
        Matcher annotationMatcher = ANNOTATION_PATTERN.matcher(content);
        if (annotationMatcher.matches()) {
            EditableJavaAnnotation.EditableJavaAnnotationBuilder builder = EditableJavaAnnotation.builder();
            String annotationName = StringUtil.trim((String)annotationMatcher.group(1));
            builder.name(annotationName);
            String annotationParameters = StringUtil.trim((String)annotationMatcher.group(2));
            if (StringUtil.isNotBlank((String)annotationParameters)) {
                Matcher parameterMatcher = ANNOTATION_PARAMETER_PATTERN.matcher(annotationParameters);
                boolean firstFind = parameterMatcher.find();
                if (!firstFind) {
                    builder.parameter("value", annotationParameters);
                } else {
                    do {
                        String parameterName = StringUtil.trim((String)parameterMatcher.group(1));
                        String parameterValue = StringUtil.trim((String)parameterMatcher.group(2));
                        builder.parameter(parameterName, parameterValue);
                    } while (parameterMatcher.find());
                }
            }
            return builder.build();
        }
        throw new JavaParsingException(JavaCodeTypes.ANNOTATION, "Failed to parse annotation");
    }
}

