/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.codetypes;

import com.github.tadukoo.java.JavaCodeType;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.importstatement.EditableJavaImportStatement;
import com.github.tadukoo.java.importstatement.JavaImportStatement;
import com.github.tadukoo.java.parsing.AbstractJavaParser;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.java.parsing.ParsingPojo;
import com.github.tadukoo.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class JavaImportStatementParser
extends AbstractJavaParser {
    private JavaImportStatementParser() {
    }

    public static JavaImportStatement parseImportStatement(String content) throws JavaParsingException {
        List<String> tokens = JavaImportStatementParser.splitContentIntoTokens(content);
        int startToken = JavaImportStatementParser.skipLeadingWhitespace(tokens);
        ParsingPojo result = JavaImportStatementParser.parseImportStatement(tokens, startToken);
        JavaImportStatementParser.verifyEndOfTokens(tokens, result, JavaCodeTypes.IMPORT_STATEMENT);
        return (JavaImportStatement)result.parsedType();
    }

    public static ParsingPojo parseImportStatement(List<String> tokens, int startToken) throws JavaParsingException {
        int currentToken;
        ArrayList<String> errors = new ArrayList<String>();
        if (StringUtil.notEquals((String)tokens.get(startToken), (String)"import")) {
            throw new JavaParsingException(JavaCodeTypes.IMPORT_STATEMENT, "First token of import statement must be 'import'");
        }
        for (currentToken = startToken + 1; currentToken < tokens.size() && WHITESPACE_MATCHER.reset(tokens.get(currentToken)).matches(); ++currentToken) {
        }
        boolean isStatic = false;
        if (currentToken < tokens.size() && (isStatic = StringUtil.equalsIgnoreCase((String)tokens.get(currentToken), (String)"static"))) {
            ++currentToken;
        }
        boolean gotSemicolon = false;
        StringBuilder importName = new StringBuilder();
        while (currentToken < tokens.size() && !gotSemicolon) {
            String token = tokens.get(currentToken);
            if (StringUtil.equalsIgnoreCase((String)token, (String)";")) {
                gotSemicolon = true;
            } else if (token.endsWith(";")) {
                importName.append(token, 0, token.length() - 1);
                gotSemicolon = true;
            } else if (!WHITESPACE_MATCHER.reset(token).matches()) {
                importName.append(token);
            }
            ++currentToken;
        }
        if (importName.isEmpty()) {
            errors.add("Failed to find import name in import statement!");
        }
        if (!gotSemicolon) {
            errors.add("Failed to find semicolon ending import statement!");
        }
        if (!errors.isEmpty()) {
            throw new JavaParsingException(JavaCodeTypes.IMPORT_STATEMENT, StringUtil.buildStringWithNewLines(errors));
        }
        return new ParsingPojo(currentToken, (JavaCodeType)EditableJavaImportStatement.builder().isStatic(isStatic).importName(importName.toString()).build());
    }
}

