/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.codetypes;

import com.github.tadukoo.java.JavaCodeType;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.packagedeclaration.EditableJavaPackageDeclaration;
import com.github.tadukoo.java.packagedeclaration.JavaPackageDeclaration;
import com.github.tadukoo.java.parsing.AbstractJavaParser;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.java.parsing.ParsingPojo;
import com.github.tadukoo.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class JavaPackageDeclarationParser
extends AbstractJavaParser {
    private JavaPackageDeclarationParser() {
    }

    public static JavaPackageDeclaration parsePackageDeclaration(String content) throws JavaParsingException {
        List<String> tokens = JavaPackageDeclarationParser.splitContentIntoTokens(content);
        int startToken = JavaPackageDeclarationParser.skipLeadingWhitespace(tokens);
        ParsingPojo result = JavaPackageDeclarationParser.parsePackageDeclaration(tokens, startToken);
        JavaPackageDeclarationParser.verifyEndOfTokens(tokens, result, JavaCodeTypes.PACKAGE_DECLARATION);
        return (JavaPackageDeclaration)result.parsedType();
    }

    public static ParsingPojo parsePackageDeclaration(List<String> tokens, int startToken) throws JavaParsingException {
        int currentToken;
        ArrayList<String> errors = new ArrayList<String>();
        if (StringUtil.notEquals((String)tokens.get(startToken), (String)"package")) {
            throw new JavaParsingException(JavaCodeTypes.PACKAGE_DECLARATION, "First token of package declaration must be 'package'");
        }
        boolean gotSemicolon = false;
        StringBuilder packageName = new StringBuilder();
        for (currentToken = startToken + 1; currentToken < tokens.size() && !gotSemicolon; ++currentToken) {
            String token = tokens.get(currentToken);
            if (StringUtil.equals((String)token, (String)";")) {
                gotSemicolon = true;
                continue;
            }
            if (token.endsWith(";")) {
                packageName.append(token, 0, token.length() - 1);
                gotSemicolon = true;
                continue;
            }
            if (WHITESPACE_MATCHER.reset(token).matches()) continue;
            packageName.append(token);
        }
        if (packageName.isEmpty()) {
            errors.add("Failed to find package name in package declaration!");
        }
        if (!gotSemicolon) {
            errors.add("Failed to find semicolon ending package declaration!");
        }
        if (!errors.isEmpty()) {
            throw new JavaParsingException(JavaCodeTypes.PACKAGE_DECLARATION, StringUtil.buildStringWithNewLines(errors));
        }
        return new ParsingPojo(currentToken, (JavaCodeType)EditableJavaPackageDeclaration.builder().packageName(packageName.toString()).build());
    }
}

