/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.comment;

import com.github.tadukoo.java.JavaCodeType;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.javadoc.Javadoc;
import com.github.tadukoo.java.parsing.AbstractJavaParser;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.java.parsing.ParsingPojo;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.tuple.Pair;
import java.util.ArrayList;
import java.util.List;

public class JavadocParser
extends AbstractJavaParser {
    private JavadocParser() {
    }

    public static Javadoc parseJavadoc(String content) throws JavaParsingException {
        List<String> tokens = JavadocParser.splitContentIntoTokens(content);
        int startToken = JavadocParser.skipLeadingWhitespace(tokens);
        ParsingPojo result = JavadocParser.parseJavadoc(tokens, startToken);
        JavadocParser.verifyEndOfTokens(tokens, result, JavaCodeTypes.JAVADOC);
        return (Javadoc)result.parsedType();
    }

    public static ParsingPojo parseJavadoc(List<String> tokens, int startToken) throws JavaParsingException {
        int currentToken;
        boolean condensed;
        ArrayList<String> errors = new ArrayList<String>();
        if (!tokens.get(startToken).startsWith("/**")) {
            errors.add("First token of Javadoc must start with '/**'");
        }
        if (!(condensed = StringUtil.notEquals((String)tokens.get(startToken), (String)"/**"))) {
            int newlineCheckToken = startToken + 1;
            while (StringUtil.notEquals((String)tokens.get(newlineCheckToken), (String)"\n")) {
                if (!WHITESPACE_MATCHER.reset(tokens.get(newlineCheckToken)).matches()) {
                    condensed = true;
                    break;
                }
                ++newlineCheckToken;
            }
        }
        String annotation = null;
        StringBuilder currentContent = new StringBuilder();
        ArrayList<String> content = new ArrayList<String>();
        String author = null;
        String version = null;
        String since = null;
        String returnVal = null;
        ArrayList<Pair<String, String>> parameters = new ArrayList<Pair<String, String>>();
        ArrayList<Pair<String, String>> throwsInfo = new ArrayList<Pair<String, String>>();
        boolean multipleAuthor = false;
        boolean multipleVersion = false;
        boolean multipleSince = false;
        boolean multipleReturn = false;
        boolean justStarting = true;
        boolean justHadNewline = true;
        boolean annotationDone = false;
        for (currentToken = startToken; currentToken < tokens.size() && !annotationDone; ++currentToken) {
            String token = tokens.get(currentToken);
            if (StringUtil.equals((String)token, (String)"*/")) {
                annotationDone = true;
                continue;
            }
            if (token.startsWith("/**") && justStarting) {
                if (StringUtil.notEquals((String)token, (String)"/**")) {
                    if ((token = StringUtil.trim((String)token.substring("/**".length()))).startsWith("@")) {
                        annotation = token.substring("@".length());
                    } else {
                        currentContent.append(token);
                    }
                    justHadNewline = false;
                }
                justStarting = false;
                continue;
            }
            if (justHadNewline) {
                if (token.startsWith("@")) {
                    annotation = token.substring("@".length());
                } else {
                    if (StringUtil.equalsAny((String)token, (String[])new String[]{"\n", "*"}) || WHITESPACE_MATCHER.reset(token).matches()) continue;
                    currentContent.append(token);
                }
                justHadNewline = false;
                continue;
            }
            if (StringUtil.equals((String)token, (String)"\n")) {
                if (annotation != null) {
                    switch (annotation) {
                        case "author": {
                            if (StringUtil.isNotBlank((String)author)) {
                                multipleAuthor = true;
                            }
                            author = StringUtil.trim((String)currentContent.toString());
                            break;
                        }
                        case "version": {
                            if (StringUtil.isNotBlank((String)version)) {
                                multipleVersion = true;
                            }
                            version = StringUtil.trim((String)currentContent.toString());
                            break;
                        }
                        case "since": {
                            if (StringUtil.isNotBlank((String)since)) {
                                multipleSince = true;
                            }
                            since = StringUtil.trim((String)currentContent.toString());
                            break;
                        }
                        case "param": {
                            String paramString = StringUtil.trim((String)currentContent.toString());
                            String paramName = StringUtil.trim((String)paramString.split("\\s+")[0]);
                            parameters.add((Pair<String, String>)Pair.of((Object)paramName, (Object)StringUtil.trim((String)paramString.substring(paramName.length()))));
                            break;
                        }
                        case "return": {
                            if (StringUtil.isNotBlank((String)returnVal)) {
                                multipleReturn = true;
                            }
                            returnVal = StringUtil.trim((String)currentContent.toString());
                            break;
                        }
                        case "throws": {
                            String throwsString = StringUtil.trim((String)currentContent.toString());
                            String throwsName = StringUtil.trim((String)throwsString.split("\\s+")[0]);
                            throwsInfo.add((Pair<String, String>)Pair.of((Object)throwsName, (Object)StringUtil.trim((String)throwsString.substring(throwsName.length()))));
                            break;
                        }
                        default: {
                            content.add("@" + annotation + " " + StringUtil.trim((String)currentContent.toString()));
                        }
                    }
                    annotation = null;
                } else {
                    content.add(StringUtil.trim((String)currentContent.toString()));
                }
                currentContent = new StringBuilder();
                justHadNewline = true;
                continue;
            }
            currentContent.append(token);
        }
        if (annotation != null) {
            switch (annotation) {
                case "author": {
                    if (StringUtil.isNotBlank(author)) {
                        multipleAuthor = true;
                    }
                    author = StringUtil.trim((String)currentContent.toString());
                    break;
                }
                case "version": {
                    if (StringUtil.isNotBlank(version)) {
                        multipleVersion = true;
                    }
                    version = StringUtil.trim((String)currentContent.toString());
                    break;
                }
                case "since": {
                    if (StringUtil.isNotBlank(since)) {
                        multipleSince = true;
                    }
                    since = StringUtil.trim((String)currentContent.toString());
                    break;
                }
                case "param": {
                    String paramString = StringUtil.trim((String)currentContent.toString());
                    String paramName = StringUtil.trim((String)paramString.split("\\s+")[0]);
                    parameters.add(Pair.of((Object)paramName, (Object)StringUtil.trim((String)paramString.substring(paramName.length()))));
                    break;
                }
                case "return": {
                    if (StringUtil.isNotBlank(returnVal)) {
                        multipleReturn = true;
                    }
                    returnVal = StringUtil.trim((String)currentContent.toString());
                    break;
                }
                case "throws": {
                    String throwsString = StringUtil.trim((String)currentContent.toString());
                    String throwsName = StringUtil.trim((String)throwsString.split("\\s+")[0]);
                    throwsInfo.add(Pair.of((Object)throwsName, (Object)StringUtil.trim((String)throwsString.substring(throwsName.length()))));
                    break;
                }
                default: {
                    content.add("@" + annotation + " " + StringUtil.trim((String)currentContent.toString()));
                    break;
                }
            }
        } else if (!currentContent.isEmpty()) {
            content.add(StringUtil.trim((String)currentContent.toString()));
        }
        if (multipleAuthor) {
            errors.add("Found multiple author strings");
        }
        if (multipleVersion) {
            errors.add("Found multiple version strings");
        }
        if (multipleSince) {
            errors.add("Found multiple since strings");
        }
        if (multipleReturn) {
            errors.add("Found multiple return strings");
        }
        if (!errors.isEmpty()) {
            throw new JavaParsingException(JavaCodeTypes.JAVADOC, StringUtil.buildStringWithNewLines(errors));
        }
        return new ParsingPojo(currentToken, (JavaCodeType)EditableJavadoc.builder().condensed(condensed).content(content).author(author).version(version).since(since).params(parameters).returnVal(returnVal).throwsInfos(throwsInfo).build());
    }
}

