/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.validation;

import com.github.tadukoo.java.annotation.EditableJavaAnnotation;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.importstatement.JavaImportStatement;
import com.github.tadukoo.java.javaclass.EditableJavaClass;
import com.github.tadukoo.java.javaclass.JavaClass;
import java.util.HashMap;
import java.util.List;

public class JavaValidator {
    public void determineCanonicalNames(JavaClass javaClass) {
        if (!(javaClass instanceof EditableJavaClass)) {
            throw new IllegalArgumentException("Need EditableJavaClass to modify canonical names");
        }
        EditableJavaClass clazz = (EditableJavaClass)javaClass;
        List<JavaImportStatement> imports = clazz.getImportStatements();
        HashMap simpleNameToCanonicalName = new HashMap();
        imports.forEach(importStmt -> {
            String importName = importStmt.getImportName();
            String[] split = importName.split("\\.");
            String simpleName = split[split.length - 1];
            simpleNameToCanonicalName.put(simpleName, importName);
        });
        List<JavaAnnotation> annotations = clazz.getAnnotations();
        for (JavaAnnotation javaAnnotation : annotations) {
            if (!(javaAnnotation instanceof EditableJavaAnnotation)) {
                throw new IllegalArgumentException("Need EditableJavaAnnotations to modify canonical names");
            }
            EditableJavaAnnotation annotation = (EditableJavaAnnotation)javaAnnotation;
            String canonicalName = (String)simpleNameToCanonicalName.get(annotation.getName());
            annotation.setCanonicalName(canonicalName);
        }
    }
}

