/*
 * Decompiled with CFR 0.152.
 */
package com.github.taymindis.jh;

import com.github.taymindis.jh.DispatcherFuture;
import com.github.taymindis.jh.DispatcherSync;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;

public abstract class Dispatcher<T>
extends HttpServletRequestWrapper {
    private static ThreadPoolExecutor bgExecutor = null;
    private static String resourcePath = null;
    private static String suffix = null;
    private static String splitter = ".";
    protected int httpStatus = -1;

    public Dispatcher(HttpServletRequest request) {
        super(request);
    }

    public boolean isSuccess() {
        return this.httpStatus >= 200 && this.httpStatus < 300;
    }

    public static Dispatcher newEvent(HttpServletRequest request, HttpServletResponse response) {
        return new DispatcherSync(request, response);
    }

    public static Dispatcher newBackgroundEvent(HttpServletRequest request, HttpServletResponse response) {
        return new DispatcherFuture(request, response);
    }

    public static void init(String $resourcePath, String $suffix, String $splitter, int nWorkerThread) {
        if (null == bgExecutor) {
            bgExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(nWorkerThread);
        }
        if (null != $resourcePath) {
            resourcePath = $resourcePath;
        }
        if (null != $suffix) {
            suffix = $suffix;
        }
        if (null != $splitter) {
            splitter = $splitter;
        }
    }

    public static boolean isDispatchFutureEnabled() {
        return bgExecutor == null;
    }

    public static ThreadPoolExecutor getBgExecutor() {
        return bgExecutor;
    }

    public static void ResetNewThreadSize(int nThread, long nSecsToWait) {
        ThreadPoolExecutor _shutdownExecutor = bgExecutor;
        try {
            bgExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(nThread);
            _shutdownExecutor.shutdown();
            if (nSecsToWait == 0L || !_shutdownExecutor.awaitTermination(nSecsToWait, TimeUnit.SECONDS)) {
                _shutdownExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void ShutDownBackgroundTask(long nSecsToWait) {
        try {
            bgExecutor.shutdown();
            if (nSecsToWait == 0L || !bgExecutor.awaitTermination(nSecsToWait, TimeUnit.SECONDS)) {
                bgExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public abstract Dispatcher addAttribute(String var1, Object var2);

    public abstract Dispatcher a(String var1, Object var2);

    public abstract Dispatcher dispatch(String var1) throws ServletException, IOException, Exception;

    public abstract void setResult(T var1);

    public abstract T getResult();

    public abstract T getResult(long var1, TimeUnit var3);

    public abstract boolean isDone();

    public abstract boolean isCancelled();
}

