/*
 * Decompiled with CFR 0.152.
 */
package com.github.taymindis.jh;

import com.github.taymindis.jh.Alertable;
import com.github.taymindis.jh.SynchronizeRequest;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SynchronizeProcess
extends SynchronizeRequest {
    private static Thread notificationThreads;
    private static Map<String, SynchronizeProcess> processNamesLiving;
    private Thread processThread;
    private Long rollingTime;
    private boolean alertable;
    private Alertable Alertable;
    private static boolean isProcessOn;

    public SynchronizeProcess(String name, Alertable Alertable_) {
        super(name);
        int errCode = this.getErrorCode();
        this.Alertable = Alertable_;
        this.alertable = this.Alertable.shouldAlert();
        if (errCode != 1) {
            String log = name + " process is still running or invalid process ";
            this.Alertable.logInfo(log);
        } else {
            if (notificationThreads == null || notificationThreads.isInterrupted() || !notificationThreads.isAlive()) {
                notificationThreads = SynchronizeProcess.newThread();
                notificationThreads.start();
            }
            this.processThread = Thread.currentThread();
            this.rollingTime = new Date().getTime();
            processNamesLiving.put(name, this);
        }
    }

    @Override
    public void release() {
        if (this.getProcessStatus() == 1) {
            processNamesLiving.remove(this.getName());
        }
        super.release();
    }

    public static void releaseAllProcess() {
        for (Map.Entry<String, SynchronizeProcess> pLiving : processNamesLiving.entrySet()) {
            SynchronizeProcess thisProcess = pLiving.getValue();
            thisProcess.release();
        }
    }

    public Thread getProcessThread() {
        return this.processThread;
    }

    public Long getRollingTime() {
        return this.rollingTime;
    }

    public void setRollingTime(Long rollingTime) {
        this.rollingTime = rollingTime;
    }

    public static void kill(String processName) {
        SynchronizeProcess syncTrackableProcess = processNamesLiving.get(processName);
        if (syncTrackableProcess != null) {
            syncTrackableProcess.getProcessThread().interrupt();
            syncTrackableProcess.release();
        }
    }

    private static Thread newThread() {
        return new Thread(){

            @Override
            public void run() {
                try {
                    while (isProcessOn) {
                        Long currTime = new Date().getTime();
                        for (Map.Entry entry : processNamesLiving.entrySet()) {
                            SynchronizeProcess thisProcess = (SynchronizeProcess)entry.getValue();
                            if (!thisProcess.alertable) continue;
                            Long startedTime = thisProcess.getRollingTime();
                            Long secs = (currTime - startedTime) / 1000L;
                            if (secs <= 300L) continue;
                            thisProcess.Alertable.triggerAlert(thisProcess.getName(), "Processing time out");
                            thisProcess.setRollingTime(currTime);
                            entry.setValue(thisProcess);
                        }
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    public static void setIsProcessOn(boolean isProcessOn) {
        SynchronizeProcess.isProcessOn = isProcessOn;
    }

    static {
        processNamesLiving = new HashMap<String, SynchronizeProcess>();
        isProcessOn = true;
        notificationThreads = SynchronizeProcess.newThread();
        notificationThreads.start();
    }
}

