/*
 * Decompiled with CFR 0.152.
 */
package com.github.taymindis.jh;

import com.github.taymindis.jh.DispatcherFuture;
import com.github.taymindis.jh.DispatcherSync;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;

public abstract class Dispatcher<T>
extends HttpServletRequestWrapper {
    private static ThreadPoolExecutor bgExecutor = null;
    public static String resourcePath = "";
    public static String suffix = "";
    public static String splitter = "^";
    protected int httpStatus = -1;

    public Dispatcher(HttpServletRequest request) {
        super(request);
    }

    public boolean isSuccess() {
        return this.httpStatus >= 200 && this.httpStatus < 300;
    }

    public static Dispatcher newEvent(HttpServletRequest request, HttpServletResponse response) {
        return new DispatcherSync(request, response);
    }

    public static Dispatcher newBackgroundEvent(HttpServletRequest request, HttpServletResponse response) {
        return new DispatcherFuture(request, response);
    }

    public static void init(String $resourcePath, String $suffix, String $splitter, int nWorkerThread) {
        if (null == bgExecutor && nWorkerThread > 0) {
            bgExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(nWorkerThread);
        }
        if (null != $resourcePath) {
            resourcePath = $resourcePath;
        }
        if (null != $suffix) {
            suffix = $suffix;
        }
        if (null != $splitter) {
            splitter = $splitter;
        }
    }

    public static Object DirectResult(String resourcePath, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Dispatcher $ev = Dispatcher.newEvent(request, response);
        return $ev.dispatch(resourcePath).getResult();
    }

    public static Object DirectResult(String resourcePath, HttpServletRequest request, HttpServletResponse response, Map<String, Object> params) throws Exception {
        Dispatcher $ev = Dispatcher.newEvent(request, response);
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            $ev.set(entry.getKey(), entry.getValue());
        }
        return $ev.dispatch(resourcePath).getResult();
    }

    public static Object DirectResult(String resourcePath, HttpServletRequest request, HttpServletResponse response, Object ... params) throws Exception {
        Dispatcher $ev = Dispatcher.newEvent(request, response);
        int sz = params.length;
        for (int i = 0; i < sz; ++i) {
            if (i % 2 != 1) continue;
            $ev.set((String)params[i - 1], params[i]);
        }
        return $ev.dispatch(resourcePath).getResult();
    }

    public static Object DirectResult(String resourcePath, Dispatcher $ev) throws Exception {
        return $ev.dispatch(resourcePath).getResult();
    }

    public static Object DirectResult(String resourcePath, Dispatcher $ev, Map<String, Object> params) throws Exception {
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            $ev.set(entry.getKey(), entry.getValue());
        }
        return $ev.dispatch(resourcePath).getResult();
    }

    public static Object DirectResult(String resourcePath, Dispatcher $ev, Object ... params) throws Exception {
        int sz = params.length;
        for (int i = 0; i < sz; ++i) {
            if (i % 2 != 1) continue;
            $ev.set((String)params[i - 1], params[i]);
        }
        return $ev.dispatch(resourcePath).getResult();
    }

    public static boolean isDispatchFutureEnabled() {
        return bgExecutor == null;
    }

    public static ThreadPoolExecutor getBgExecutor() {
        return bgExecutor;
    }

    public static void ResetNewThreadSize(int nThread, long nSecsToWait) {
        if (nThread > 0) {
            ThreadPoolExecutor _shutdownExecutor = bgExecutor;
            try {
                bgExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(nThread);
                if (_shutdownExecutor != null) {
                    _shutdownExecutor.shutdown();
                    if (nSecsToWait == 0L || !_shutdownExecutor.awaitTermination(nSecsToWait, TimeUnit.SECONDS)) {
                        _shutdownExecutor.shutdownNow();
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static void ShutDownBackgroundTask(long nSecsToWait) {
        try {
            bgExecutor.shutdown();
            if (nSecsToWait == 0L || !bgExecutor.awaitTermination(nSecsToWait, TimeUnit.SECONDS)) {
                bgExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public abstract Dispatcher addAttribute(String var1, Object var2);

    public abstract Dispatcher set(String var1, Object var2);

    public abstract Object get(String var1);

    public abstract Dispatcher dispatch(String var1) throws ServletException, IOException, Exception;

    public abstract void setResult(T var1);

    public abstract T getResult();

    public abstract T getResult(long var1, TimeUnit var3);

    public abstract boolean isDone();

    public abstract boolean isCancelled();
}

