/*
 * Decompiled with CFR 0.152.
 */
package com.github.taymindis;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class OJHSynchronizeRequest {
    private final String name;
    private int processStatus;
    private static final Set<String> _$requests = Collections.synchronizedSet(new HashSet());
    public static final int PROCESS_IS_OK_TO_RUN = 1;
    public static final int PROCESS_IS_ALREADY_RUNNING = 2;
    public static final int PROCESS_HAS_ERROR = 3;
    public static final int PROCESS_SHOULD_NOT_RUN = 4;
    public static final int PROCESS_NAME_IS_EMPTY = 5;

    public OJHSynchronizeRequest(String name) {
        this.name = name;
        this.processStatus = name == null ? 5 : (!_$requests.add(this.name) ? 2 : 1);
    }

    public String getName() {
        return this.name;
    }

    public boolean hasError() {
        return this.processStatus != 1;
    }

    public int getErrorCode() {
        return this.processStatus;
    }

    public int getProcessStatus() {
        return this.processStatus;
    }

    public void release() {
        if (this.processStatus == 1) {
            _$requests.remove(this.name);
        }
    }

    public static boolean isProcessBusy(String name) {
        return name != null && _$requests.contains(name);
    }

    public static void flushAll() {
        OJHSynchronizeRequest.flush(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flush(String nameStartWith) {
        if (nameStartWith == null) {
            _$requests.clear();
        } else {
            Set<String> set = _$requests;
            synchronized (set) {
                Iterator<String> itr = _$requests.iterator();
                while (itr.hasNext()) {
                    String procName = itr.next();
                    if (!procName.startsWith(nameStartWith)) continue;
                    itr.remove();
                }
            }
        }
    }
}

