package testoptimal.api;
import java.util.Date;
import com.google.gson.Gson;

/**
 * Copyright 2020 TestOptimal LLC
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 * @author Yaxiong Lin
 *
 */
public class APIError extends Exception {
	public Date timestamp;
	public String message;
	public String error;
	public String path;
	public int status;
	
	public APIError (int status_p, String error_p, String message_p, String path_p) {
		super(message_p);
		this.status = status_p;
		this.error = error_p;
		this.message = message_p;
		this.path = path_p;
	}
	
	public String toString() {
		Gson gson = new Gson();
		return gson.toJson(this);
	}
}
