/*
 * Decompiled with CFR 0.152.
 */
package testoptimal.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import testoptimal.api.Constants;

public class RunResult {
    private static Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public Constants.Status status = Constants.Status.success;
    public String errorMsg;
    public long execMillis;
    public Map<String, Object> results = new HashMap<String, Object>();

    public List<TestPath> getPathList() {
        List pathList = (List)this.results.get("pathList");
        AtomicInteger tcId = new AtomicInteger();
        return pathList.stream().map(p -> new TestPath((List<List<String>>)p, tcId.getAndIncrement())).collect(Collectors.toList());
    }

    public String toString() {
        return gson.toJson((Object)this);
    }

    public class TestStep {
        public String stateName;
        public String transName;
        public String status;

        protected TestStep(List<String> traversal_p) {
            if (traversal_p.size() > 0) {
                this.stateName = traversal_p.get(0);
            }
            if (traversal_p.size() > 1) {
                this.transName = traversal_p.get(1);
            }
            if (traversal_p.size() > 2) {
                this.status = traversal_p.get(2);
            }
        }

        public String toString() {
            return gson.toJson((Object)this);
        }
    }

    public class TestPath {
        public String status;
        public int id;
        public List<TestStep> stepList = new ArrayList<TestStep>();

        public TestPath(List<List<String>> testCase_p, int tcId_p) {
            this.id = tcId_p;
            this.stepList = testCase_p.stream().map(s -> new TestStep((List<String>)s)).collect(Collectors.toList());
            this.status = this.stepList.stream().filter(s -> s.status != null && s.status.indexOf("fail") >= 0).count() > 0L ? "failed" : "passed";
        }

        public String toString() {
            return gson.toJson((Object)this);
        }
    }
}

