/*
 * Decompiled with CFR 0.152.
 */
package com.github.thomasridd.flatsy;

import com.github.thomasridd.flatsy.FlatsyDatabase;
import com.github.thomasridd.flatsy.FlatsyFlatFileDatabase;
import com.github.thomasridd.flatsy.operations.operators.OperatorCommandLineParser;
import com.github.thomasridd.flatsy.query.FlatsyCursor;
import com.github.thomasridd.flatsy.query.matchers.MatcherCommandLineParser;
import com.github.thomasridd.flatsy.util.FlatsyUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class FlatsyCommandLine {
    FlatsyDatabase db;
    List<String> queryCommands = new ArrayList<String>();
    public OutputStream defaultOut = System.out;

    public FlatsyCommandLine() {
    }

    public FlatsyCommandLine(String command) {
        this.runCommand(command);
    }

    public FlatsyCommandLine(List<String> commands) {
        this.runScript(commands);
    }

    public FlatsyCommandLine(Path script) throws IOException {
        this.runScript(script);
    }

    public FlatsyCommandLine(InputStream stream) {
        this.runScript(stream);
    }

    public boolean runCommand(String command) {
        if (command.trim().length() == 0) {
            return true;
        }
        List<String> args = FlatsyUtil.commandArguments(command);
        String action = args.get(0).trim();
        if (action.equalsIgnoreCase("from")) {
            this.db = new FlatsyFlatFileDatabase(Paths.get(args.get(1).trim(), new String[0]));
            this.queryCommands = new ArrayList<String>();
            return true;
        }
        if (action.equalsIgnoreCase("filter")) {
            this.queryCommands.add(command);
            return true;
        }
        if (action.equalsIgnoreCase("clear")) {
            this.queryCommands = new ArrayList<String>();
            return true;
        }
        if (action.equalsIgnoreCase("print")) {
            System.out.println("");
            System.out.println("FROM " + this.db.toString());
            for (String query : this.queryCommands) {
                System.out.println(query);
            }
            return true;
        }
        long start = System.currentTimeMillis();
        boolean result = this.applyOperation(command);
        long total = System.currentTimeMillis() - start;
        System.out.println(command + " >> Applied in " + total + " milliseconds");
        return result;
    }

    public boolean runScript(List<String> commands) {
        boolean result = true;
        for (String command : commands) {
            result = result && this.runCommand(command);
        }
        return result;
    }

    public boolean runScript(Path path) throws IOException {
        boolean result = true;
        try (Scanner scanner = new Scanner(Files.newInputStream(path, new OpenOption[0]));){
            while (scanner.hasNextLine()) {
                result = result && this.runCommand(scanner.nextLine());
            }
        }
        return result;
    }

    public boolean runScript(InputStream stream) {
        boolean result = true;
        Scanner scanner = new Scanner(stream);
        while (scanner.hasNextLine()) {
            result = result && this.runCommand(scanner.nextLine());
        }
        return result;
    }

    public FlatsyCursor cursor(Path scriptPath) throws IOException {
        this.db = null;
        try (Scanner scanner = new Scanner(Files.newInputStream(scriptPath, new OpenOption[0]));){
            while (scanner.hasNextLine()) {
                this.buildCursor(scanner.nextLine());
            }
        }
        return MatcherCommandLineParser.cursorFromFilterCommands(this.db, this.queryCommands);
    }

    public FlatsyCursor cursor(List<String> commands) {
        for (String command : commands) {
            this.buildCursor(command);
        }
        return MatcherCommandLineParser.cursorFromFilterCommands(this.db, this.queryCommands);
    }

    public FlatsyCursor cursor() {
        return MatcherCommandLineParser.cursorFromFilterCommands(this.db, this.queryCommands);
    }

    private boolean buildCursor(String command) {
        if (command.trim().length() == 0) {
            return true;
        }
        List<String> args = FlatsyUtil.commandArguments(command);
        String action = args.get(0).trim();
        if (action.equalsIgnoreCase("from")) {
            this.db = new FlatsyFlatFileDatabase(Paths.get(args.get(1).trim(), new String[0]));
            this.queryCommands = new ArrayList<String>();
            return true;
        }
        if (action.equalsIgnoreCase("filter")) {
            this.queryCommands.add(command);
            return true;
        }
        return false;
    }

    protected boolean applyOperation(String command) {
        if (command.trim().equalsIgnoreCase("")) {
            return true;
        }
        FlatsyCursor query = MatcherCommandLineParser.cursorFromFilterCommands(this.db, this.queryCommands);
        if (query == null) {
            return false;
        }
        OperatorCommandLineParser.applyFromCommand(query, command, this.defaultOut);
        return true;
    }

    public static void main(String[] args) {
        FlatsyCommandLine cli = new FlatsyCommandLine();
        Scanner scanner = new Scanner(System.in);
        while (true) {
            System.out.print("flatsy >> ");
            String command = scanner.nextLine();
            cli.runCommand(command);
        }
    }
}

