/*
 * Decompiled with CFR 0.152.
 */
package com.github.thomasridd.flatsy.operations.operators;

import com.github.thomasridd.flatsy.FlatsyObject;
import com.github.thomasridd.flatsy.operations.operators.FlatsyOperator;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import net.minidev.json.JSONArray;

public class JSONObjectsToOutput
implements FlatsyOperator {
    OutputStream stream;
    List<String> subpaths;
    String objectPath;

    public JSONObjectsToOutput(OutputStream stream, String objectPath, List<String> subpaths) {
        this.stream = stream;
        this.subpaths = subpaths;
        this.objectPath = objectPath;
    }

    @Override
    public void apply(FlatsyObject object) {
        try {
            DocumentContext context = JsonPath.parse((InputStream)object.retrieveStream());
            try {
                JSONArray objects = (JSONArray)context.read(this.objectPath, new Predicate[0]);
                for (Object arrayObject : objects) {
                    String objectString = object.uri + "\t";
                    LinkedHashMap hashMap = (LinkedHashMap)arrayObject;
                    for (String path : this.subpaths) {
                        if (((HashMap)hashMap).keySet().contains(path)) {
                            String value = ((String)((HashMap)hashMap).get(path)).toString().replace("\n", " ").replace("\r", " ");
                            objectString = objectString + value + "\t";
                            continue;
                        }
                        objectString = objectString + "\t";
                    }
                    this.stream.write((objectString + "\n").getBytes());
                }
            }
            catch (PathNotFoundException pathNotFoundException) {
            }
        }
        catch (IOException e) {
            System.out.println("Failed to print for uri: " + object.uri);
        }
    }
}

