/*
 * Decompiled with CFR 0.152.
 */
package com.github.thomasridd.flatsy.query.matchers;

import com.github.thomasridd.flatsy.FlatsyObject;
import com.github.thomasridd.flatsy.FlatsyObjectType;
import com.github.thomasridd.flatsy.query.matchers.FlatsyMatcher;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.InputStream;

public class JSONPathExists
implements FlatsyMatcher {
    String jsonPath = null;

    public JSONPathExists(String jsonPath) {
        this.jsonPath = jsonPath;
    }

    @Override
    public boolean matches(FlatsyObject object) {
        if (object.getType() == FlatsyObjectType.Folder) {
            return false;
        }
        try {
            DocumentContext context = JsonPath.parse((InputStream)object.retrieveStream());
            context.read(this.jsonPath, new Predicate[0]);
            return true;
        }
        catch (IOException e) {
            System.out.println("Could not assess " + object.uri + " for " + this.jsonPath);
            return false;
        }
        catch (PathNotFoundException e) {
            return false;
        }
    }
}

