/*
 * Decompiled with CFR 0.152.
 */
package com.github.thorbenkuck.scripting;

import com.github.thorbenkuck.scripting.ConvertToIntegerFunction;
import com.github.thorbenkuck.scripting.Parser;
import com.github.thorbenkuck.scripting.PrintFunction;
import com.github.thorbenkuck.scripting.PrintLineFunction;
import com.github.thorbenkuck.scripting.Register;
import com.github.thorbenkuck.scripting.RequireIsSetFunction;

public interface Function {
    public static final String NO_RETURN_VALUE = "void";
    public static final java.util.function.Function<String, String> asStringValue = string -> "\"" + string + "\"";
    public static final java.util.function.Function<String, Boolean> isVariable = string -> !string.startsWith("\"") && !string.endsWith("\"");

    public static Function print() {
        return new PrintFunction();
    }

    public static Function println() {
        return new PrintLineFunction();
    }

    public static Function require() {
        return new RequireIsSetFunction();
    }

    public static void applyDefaults(Parser parser) {
        parser.addFunction(Function.convertToInt());
        parser.addFunction(Function.require());
        parser.addFunction(Function.print());
        parser.addFunction(Function.println());
    }

    public static Function convertToInt() {
        return new ConvertToIntegerFunction();
    }

    public String getFunctionName();

    default public String calculate(String[] args, Register register) {
        return NO_RETURN_VALUE;
    }

    default public void onParse(String[] args, Parser parser, int lineNumber) {
    }
}

