/*
 * Decompiled with CFR 0.152.
 */
package com.github.thorbenkuck.scripting;

import com.github.thorbenkuck.scripting.Line;
import com.github.thorbenkuck.scripting.Parser;
import com.github.thorbenkuck.scripting.Register;
import com.github.thorbenkuck.scripting.Rule;
import java.util.function.Consumer;

class IntegerIncrementRule
implements Rule {
    IntegerIncrementRule() {
    }

    @Override
    public boolean applies(Line line) {
        return line.matches("\\+\\+[a-zA-Z0-9]");
    }

    @Override
    public Consumer<Register> apply(Line line, Parser parser, int linePointer) {
        final String variable = line.subpart(2, line.length()).toString();
        return new Consumer<Register>(){

            @Override
            public void accept(Register register) {
                String currentValue = register.get(variable);
                int intValue = Integer.parseInt(currentValue);
                register.put(variable, String.valueOf(++intValue));
            }

            public String toString() {
                return "increase " + variable;
            }
        };
    }
}

