/*
 * Decompiled with CFR 0.152.
 */
package com.github.thorbenkuck.scripting;

import com.github.thorbenkuck.scripting.Function;
import com.github.thorbenkuck.scripting.Line;
import com.github.thorbenkuck.scripting.Parser;
import com.github.thorbenkuck.scripting.Register;
import com.github.thorbenkuck.scripting.Rule;
import com.github.thorbenkuck.scripting.exceptions.ExecutionRuntimeException;
import java.util.function.Consumer;

class VariableDefinitionRule
implements Rule {
    VariableDefinitionRule() {
    }

    @Override
    public boolean applies(Line line) {
        return line.matches("[a-zA-Z0-9]+[ ]*=[ ]*[a-zA-Z0-9]+");
    }

    @Override
    public Consumer<Register> apply(final Line line, final Parser parser, int linePointer) {
        line.trimWhiteSpaces();
        final StringBuilder stringBuilder = new StringBuilder(line.toString());
        final String name = this.parseVariableName(stringBuilder);
        return new Consumer<Register>(){

            @Override
            public void accept(Register register) {
                if ("null".equals(register.get(name))) {
                    parser.error(name + " is not defined", line.getLineNumber());
                } else {
                    String value = stringBuilder.toString();
                    if (Function.isVariable.apply(value).booleanValue()) {
                        String savedValue = register.get(value);
                        if ("null".equals(savedValue)) {
                            throw new ExecutionRuntimeException("Tried to set null variable!");
                        }
                        register.put(name, savedValue);
                    } else {
                        register.put(name, value);
                    }
                }
            }

            public String toString() {
                return "SetVariable(" + name + " to " + stringBuilder.toString() + ")";
            }
        };
    }

    private String parseVariableName(StringBuilder line) {
        String lineString = line.toString();
        String name = line.substring(0, lineString.indexOf("="));
        line.delete(0, name.length() + 1);
        return name;
    }
}

