/*
 * Decompiled with CFR 0.152.
 */
package com.github.thorbenkuck.scripting;

import com.github.thorbenkuck.scripting.Line;
import com.github.thorbenkuck.scripting.LineParser;
import com.github.thorbenkuck.scripting.LineProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

class DefaultLineParser
implements LineParser {
    private final List<Line> lines = new ArrayList<Line>();
    private final AtomicInteger linePointer = new AtomicInteger(-1);
    private final AtomicBoolean linePointerFreeze = new AtomicBoolean(false);

    DefaultLineParser() {
    }

    DefaultLineParser(String rawScript) {
        this.setLines(rawScript);
    }

    DefaultLineParser(LineProvider lineProvider) {
        this.setLines(lineProvider);
    }

    private List<Line> parseLines(LineProvider lineProvider) {
        return lineProvider.provide();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLines(LineProvider provider) {
        List<Line> list = this.lines;
        synchronized (list) {
            this.lines.addAll(this.parseLines(provider));
        }
    }

    void setLines(String rawScript) {
        this.setLines(LineProvider.ofString(rawScript));
    }

    private void incrementLinePointer() {
        if (!this.linePointerFreeze.get()) {
            this.linePointer.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineCount() {
        List<Line> list = this.lines;
        synchronized (list) {
            return this.lines.size();
        }
    }

    private void unfreezeLinePointer() {
        this.linePointerFreeze.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Line getNext() {
        this.incrementLinePointer();
        this.unfreezeLinePointer();
        List<Line> list = this.lines;
        synchronized (list) {
            return this.lines.get(this.linePointer.get());
        }
    }

    @Override
    public boolean hasNext() {
        boolean freeze = this.linePointerFreeze.get();
        if (freeze) {
            return this.getLinePointer() < this.getLineCount();
        }
        return this.getLinePointer() + 1 < this.getLineCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Line getCurrent() {
        List<Line> list = this.lines;
        synchronized (list) {
            return this.lines.get(this.linePointer.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Line getLine(int lineNumber) {
        List<Line> list = this.lines;
        synchronized (list) {
            return this.lines.get(lineNumber);
        }
    }

    @Override
    public void freezeLinePointer() {
        this.linePointerFreeze.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLinePointer(int to) {
        int lineSize = this.getLineCount();
        if (to < 0 || lineSize < to) {
            throw new IllegalArgumentException("Line pointer has to be between 0 and " + lineSize + ". Provided: " + to);
        }
        AtomicInteger atomicInteger = this.linePointer;
        synchronized (atomicInteger) {
            this.linePointer.set(to);
        }
    }

    @Override
    public int getLinePointer() {
        return this.linePointer.get();
    }

    @Override
    public Iterator<Line> iterator() {
        return new LineIterator(this.lines);
    }

    private final class LineIterator
    implements Iterator<Line> {
        private final Queue<Line> lines;

        private LineIterator(Collection<Line> lines) {
            this.lines = new LinkedList<Line>(lines);
        }

        @Override
        public boolean hasNext() {
            return this.lines.peek() != null;
        }

        @Override
        public Line next() {
            return this.lines.poll();
        }
    }
}

