/*
 * Decompiled with CFR 0.152.
 */
package org.treeleaf.web;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.treeleaf.common.json.Jsoner;
import org.treeleaf.web.Text;

public class Json
extends Text {
    private static Logger log = LoggerFactory.getLogger(Json.class);
    private String retCode = "000000";
    private String msg;
    private Object data;

    public Json() {
    }

    public Json(String retCode, String msg) {
        this.retCode = retCode;
        this.msg = msg;
    }

    public Json(Object data) {
        this.data = data;
    }

    @Override
    public String getContent() {
        Map<String, Object> map;
        if (this.data != null) {
            if (this.data instanceof Map) {
                map = (Map)this.data;
            } else if (this.data instanceof Collection || this.data.getClass().isArray()) {
                map = new HashMap();
                map.put("array", this.data);
            } else {
                try {
                    map = PropertyUtils.describe((Object)this.data);
                    map.remove("class");
                }
                catch (Exception e) {
                    log.error("\u5c06Json.data\u8f6cmap\u5931\u8d25", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        } else {
            map = new HashMap<String, String>();
        }
        map.put("retCode", this.retCode);
        if (this.msg != null) {
            map.put("msg", this.msg);
        }
        return Jsoner.toJson(map);
    }

    public String getRetCode() {
        return this.retCode;
    }

    public void setRetCode(String retCode) {
        this.retCode = retCode;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }
}

