/*
 * Decompiled with CFR 0.152.
 */
package org.treeleaf.web.spring.config;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.treeleaf.common.safe.Des3;

public class DecryptPropertyConfigurer
extends PropertyPlaceholderConfigurer {
    private static Logger log = LoggerFactory.getLogger(DecryptPropertyConfigurer.class);
    private String key;
    private List<String> decryptKeyNames = new ArrayList<String>();

    protected void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, Properties props) throws BeansException {
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            String value;
            String name = (String)names.nextElement();
            if (!this.decryptKeyNames.contains(name) || StringUtils.isBlank((CharSequence)(value = props.getProperty(name)))) continue;
            try {
                value = Des3.decryptByBase64((String)value, (String)this.key);
            }
            catch (Exception e) {
                log.error("3desc\u89e3\u6790\u914d\u7f6e\u6587\u4ef6\u5931\u8d25,\u9519\u8bef\u7684\u503c:{}", (Object)value, (Object)e);
                throw new RuntimeException("3desc\u89e3\u6790\u914d\u7f6e\u6587\u4ef6\u5931\u8d25,\u9519\u8bef\u7684\u503c:" + value, e);
            }
            props.setProperty(name, value);
        }
        super.processProperties(beanFactoryToProcess, props);
    }

    public void setDecryptKeyNames(List<String> decryptKeyNames) {
        this.decryptKeyNames = decryptKeyNames;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

