/*
 * Decompiled with CFR 0.152.
 */
package org.treeleaf.web.spring.handler;

import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.treeleaf.common.bean.ClientInfo;

public class ClientInfoHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private static Logger log = LoggerFactory.getLogger(ClientInfoHandlerMethodArgumentResolver.class);
    private static final String phoneReg = "\\b(ip(hone|od)|android|opera m(ob|in)i|windows (phone|ce)|blackberry|s(ymbian|eries60|amsung)|p(laybook|alm|rofile/midp|laystation portable)|nokia|fennec|htc[-_]|mobile|up.browser|[1-4][0-9]{2}x[1-4][0-9]{2})\\b";
    private static final String tableReg = "\\b(ipad|tablet|(Nexus 7)|up.browser|[1-4][0-9]{2}x[1-4][0-9]{2})\\b";
    private static final Pattern phonePat = Pattern.compile("\\b(ip(hone|od)|android|opera m(ob|in)i|windows (phone|ce)|blackberry|s(ymbian|eries60|amsung)|p(laybook|alm|rofile/midp|laystation portable)|nokia|fennec|htc[-_]|mobile|up.browser|[1-4][0-9]{2}x[1-4][0-9]{2})\\b", 2);
    private static final Pattern tablePat = Pattern.compile("\\b(ipad|tablet|(Nexus 7)|up.browser|[1-4][0-9]{2}x[1-4][0-9]{2})\\b", 2);

    public boolean supportsParameter(MethodParameter methodParameter) {
        return ClientInfo.class.equals((Object)methodParameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest nativeWebRequest, WebDataBinderFactory webDataBinderFactory) throws Exception {
        HttpServletRequest request = (HttpServletRequest)nativeWebRequest.getNativeRequest(HttpServletRequest.class);
        ClientInfo clientInfo = new ClientInfo();
        if (request != null) {
            clientInfo.setIp(this.getIp(request));
            clientInfo.setMobile(this.isMobile(request));
        }
        return clientInfo;
    }

    protected boolean isMobile(HttpServletRequest request) {
        if ("0".equals(request.getParameter("_m"))) {
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)request.getHeader("x-wap-profile"))) {
            return true;
        }
        String userAgent = StringUtils.defaultString((String)request.getHeader("USER-AGENT")).toLowerCase();
        return phonePat.matcher(userAgent).find() || tablePat.matcher(userAgent).find();
    }

    protected String getIp(HttpServletRequest request) {
        String ip = request.getHeader("X-Real-IP");
        if (StringUtils.isBlank((CharSequence)ip)) {
            ip = request.getRemoteAddr();
        }
        if ("0:0:0:0:0:0:0:1".equals(ip)) {
            ip = "127.0.0.1";
        }
        return ip;
    }
}

