/*
 * Decompiled with CFR 0.152.
 */
package org.treeleaf.web.spring.handler;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.treeleaf.web.Html;

public class HtmlHandlerMethodReturnValueHandler
implements HandlerMethodReturnValueHandler {
    private static Logger log = LoggerFactory.getLogger(HtmlHandlerMethodReturnValueHandler.class);

    public boolean supportsReturnType(MethodParameter returnType) {
        return Html.class.isAssignableFrom(returnType.getParameterType());
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        Html html = (Html)returnValue;
        if (html != null) {
            if (html.getPath() != null) {
                mavContainer.setViewName(html.getPath());
            }
            if (html.getModel() != null) {
                mavContainer.getModel().put((Object)"model", html.getModel());
            }
        }
    }
}

