/*
 * Decompiled with CFR 0.152.
 */
package org.treeleaf.web.spring.handler;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.view.RedirectView;
import org.treeleaf.common.http.basic.Http;
import org.treeleaf.web.Redirect;

public class RedirectHandlerMethodReturnValueHandler
implements HandlerMethodReturnValueHandler {
    private static Logger log = LoggerFactory.getLogger(RedirectHandlerMethodReturnValueHandler.class);

    public boolean supportsReturnType(MethodParameter returnType) {
        return Redirect.class.isAssignableFrom(returnType.getParameterType());
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        Redirect redirect = (Redirect)returnValue;
        String param = Http.param2UrlParam(redirect.getParam(), (String[])new String[0]);
        StringBuilder stringBuilder = new StringBuilder(redirect.getPath());
        if (StringUtils.isNotBlank((CharSequence)param)) {
            stringBuilder.append('?');
            stringBuilder.append(param);
        }
        mavContainer.setView((Object)new RedirectView(stringBuilder.toString()));
    }
}

