/*
 * Decompiled with CFR 0.152.
 */
package org.treeleaf.web.spring.handler;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.treeleaf.web.Text;
import org.treeleaf.web.spring.Jsonp;
import org.treeleaf.web.spring.view.JsonpView;
import org.treeleaf.web.spring.view.TextView;

public class TextHandlerMethodReturnValueHandler
implements HandlerMethodReturnValueHandler {
    private static Logger log = LoggerFactory.getLogger(TextHandlerMethodReturnValueHandler.class);

    public boolean supportsReturnType(MethodParameter returnType) {
        return Text.class.isAssignableFrom(returnType.getParameterType());
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        Text text = (Text)returnValue;
        if (text != null) {
            if (text instanceof Jsonp) {
                mavContainer.setView((Object)new JsonpView(text));
            } else {
                mavContainer.setView((Object)new TextView(text));
            }
        } else {
            log.warn("\u8fd4\u56deText\u7c7b\u578b\u65f6\u9519\u8bef,\u8fd4\u56de\u4e86null");
        }
    }
}

