/*
 * Decompiled with CFR 0.152.
 */
package org.treeleaf.web.spring.interceptor;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class MultipleHandlerInerceptor
implements HandlerInterceptor {
    private List<HandlerInterceptor> handlers = new ArrayList<HandlerInterceptor>();
    private static Logger log = LoggerFactory.getLogger(MultipleHandlerInerceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        for (HandlerInterceptor item : this.handlers) {
            if (item.preHandle(request, response, handler)) continue;
            return false;
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        for (int i = this.handlers.size() - 1; i >= 0; --i) {
            HandlerInterceptor item = this.handlers.get(i);
            try {
                item.postHandle(request, response, handler, modelAndView);
                continue;
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        for (int i = this.handlers.size() - 1; i >= 0; --i) {
            HandlerInterceptor item = this.handlers.get(i);
            try {
                item.afterCompletion(request, response, handler, ex);
                continue;
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
    }

    public void setHandlers(List<HandlerInterceptor> handlers) {
        this.handlers = handlers;
    }
}

