/*
 * Decompiled with CFR 0.152.
 */
package org.treeleaf.web.spring.interceptor;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.treeleaf.common.exception.BaseException;
import org.treeleaf.common.exception.RetCodeSupport;

public class PrintLogHandlerInerceptor
implements HandlerInterceptor {
    protected Logger log = LoggerFactory.getLogger(PrintLogHandlerInerceptor.class);
    private static final char URL_SYMBOL_EQUEST = '=';
    private static final char URL_SYMBOL_AND = '&';
    private boolean accessLog = true;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            request.setAttribute("_invokeStartTime", (Object)System.currentTimeMillis());
            if (!this.accessLog) {
                return true;
            }
            StringBuilder sb = new StringBuilder();
            Enumeration enumeration = request.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                sb.append(name);
                sb.append('=');
                sb.append(request.getParameter(name));
                sb.append('&');
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            HandlerMethod hm = (HandlerMethod)handler;
            String className = hm.getBean().getClass().getSimpleName();
            this.log.info("\u5f00\u59cb\u8c03\u7528[{}][{}.{}]\u63a5\u53e3, \u4f20\u5165\u53c2\u6570:{}", new Object[]{request.getServletPath(), className, hm.getMethod().getName(), sb});
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception e) throws Exception {
        if (handler instanceof HandlerMethod) {
            HandlerMethod hm = (HandlerMethod)handler;
            String classSimpleName = hm.getBean().getClass().getSimpleName();
            long t = (Long)request.getAttribute("_invokeStartTime");
            long ms = System.currentTimeMillis() - t;
            e = e != null ? e : (Exception)request.getAttribute("_exception");
            String msg = String.format("\u7ed3\u675f\u8c03\u7528[%s][%s]\u63a5\u53e3! \u7528\u65f6: %s \u6beb\u79d2!", request.getServletPath(), classSimpleName + "." + hm.getMethod().getName(), ms);
            if (e != null) {
                if (e instanceof BaseException && e.getCause() == null) {
                    msg = e instanceof RetCodeSupport ? msg + String.format(" \u51fa\u73b0\u9519\u8bef:[%s][%s]", ((RetCodeSupport)e).getRetCode(), e.getMessage()) : msg + String.format(" \u51fa\u73b0\u9519\u8bef:[%s]", e.getMessage());
                    this.log.info(msg);
                } else {
                    msg = msg + " \u51fa\u73b0\u5f02\u5e38:";
                    this.log.error(msg, (Throwable)e);
                }
            } else if (this.accessLog) {
                this.log.info(msg);
            }
        }
    }

    public void setAccessLog(boolean accessLog) {
        this.accessLog = accessLog;
    }
}

