/*
 * Decompiled with CFR 0.152.
 */
package org.treeleaf.web.spring.resovler;

import java.util.HashMap;
import org.treeleaf.common.exception.BaseException;
import org.treeleaf.common.exception.RetCodeSupport;
import org.treeleaf.web.Html;
import org.treeleaf.web.Json;
import org.treeleaf.web.Redirect;
import org.treeleaf.web.Result;
import org.treeleaf.web.spring.resovler.ErrorInfo;
import org.treeleaf.web.spring.resovler.ExExceptionHanlder;

public class DefaultExExceptionHandler
implements ExExceptionHanlder {
    private String tip = "\u7f51\u7edc\u7e41\u5fd9,\u8bf7\u7a0d\u540e\u5c1d\u8bd5";
    private String errorView = "error";
    private boolean redirect = true;

    @Override
    public Result invoke(ErrorInfo errorInfo) {
        if (".json".equals(errorInfo.getExt())) {
            Json json;
            if (errorInfo.getException() instanceof RetCodeSupport) {
                RetCodeSupport support = (RetCodeSupport)errorInfo.getException();
                json = new Json(support.getRetCode(), errorInfo.getException().getMessage());
            } else {
                json = new Json("999999", this.tip);
            }
            return json;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        if (errorInfo.getException() instanceof BaseException) {
            param.put("msg", errorInfo.getException().getMessage());
        } else {
            param.put("msg", this.tip);
        }
        if (errorInfo.getException() instanceof RetCodeSupport) {
            param.put("retCode", ((RetCodeSupport)errorInfo.getException()).getRetCode());
        } else {
            param.put("retCode", "999999");
        }
        if (this.redirect) {
            return new Redirect(this.errorView, param);
        }
        param.put("exception", (String)((Object)errorInfo.getException()));
        return new Html(this.errorView, param);
    }

    public void setTip(String tip) {
        this.tip = tip;
    }

    public void setErrorView(String errorView) {
        this.errorView = errorView;
    }

    public void setRedirect(boolean redirect) {
        this.redirect = redirect;
    }
}

