/*
 * Decompiled with CFR 0.152.
 */
package org.treeleaf.web.spring.resovler;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.springframework.web.servlet.view.RedirectView;
import org.treeleaf.common.http.basic.Http;
import org.treeleaf.web.Html;
import org.treeleaf.web.Redirect;
import org.treeleaf.web.Result;
import org.treeleaf.web.Text;
import org.treeleaf.web.spring.resovler.ErrorInfo;
import org.treeleaf.web.spring.resovler.ExExceptionHanlder;
import org.treeleaf.web.spring.view.TextView;

public class ExHandlerExceptionResolver
extends AbstractHandlerExceptionResolver {
    private static Logger log = LoggerFactory.getLogger(ExHandlerExceptionResolver.class);
    private int status = 200;
    private ExExceptionHanlder exExceptionHanlder;

    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        request.setAttribute("_exception", (Object)ex);
        if (this.exExceptionHanlder != null) {
            String path = request.getServletPath();
            String ext = this.getUriExt(path);
            ErrorInfo errorInfo = new ErrorInfo();
            errorInfo.setException(ex);
            errorInfo.setUri(request.getRequestURI());
            errorInfo.setExt(ext);
            Result result = this.exExceptionHanlder.invoke(errorInfo);
            if (result != null) {
                response.setStatus(this.status);
                if (result instanceof Text) {
                    return new ModelAndView((View)new TextView((Text)result));
                }
                if (result instanceof Html) {
                    Html html = (Html)result;
                    ModelAndView mav = new ModelAndView(html.getPath());
                    mav.addObject("model", html.getModel());
                    return mav;
                }
                if (result instanceof Redirect) {
                    Redirect redirect = (Redirect)result;
                    String param = Http.param2UrlParam(redirect.getParam(), (String[])new String[0]);
                    StringBuilder stringBuilder = new StringBuilder(redirect.getPath());
                    if (StringUtils.isNotBlank((CharSequence)param)) {
                        stringBuilder.append('?');
                        stringBuilder.append(param);
                    }
                    ModelAndView mav = new ModelAndView();
                    mav.setView((View)new RedirectView(stringBuilder.toString()));
                    return mav;
                }
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6e32\u67d3\u7c7b\u578b:" + result.getClass().getName());
            }
        }
        return null;
    }

    private String getUriExt(String path) {
        String ext = "";
        int index = path.lastIndexOf(".");
        if (index > 0) {
            ext = path.substring(index);
        }
        return ext;
    }

    public void setExExceptionHanlder(ExExceptionHanlder exExceptionHanlder) {
        this.exExceptionHanlder = exExceptionHanlder;
    }

    public void setStatus(int status) {
        this.status = status;
    }
}

