/*
 * Copyright (c) 2017 Rumen Nikiforov <unafraid89@gmail.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package com.github.unafraid.plugins.installers;

import com.github.unafraid.plugins.AbstractPlugin;
import com.github.unafraid.plugins.exceptions.PluginException;

/**
 * A simple interface to provide a possibility to register several types of custom installers.
 * @author UnAfraid
 */
public interface IPluginInstaller {
	/**
	 * Triggered whenever the plugin is being installed.
	 * @param plugin the plugin
	 * @throws PluginException
	 */
	void install(AbstractPlugin plugin) throws PluginException;
	
	/**
	 * Triggered whenever the plugin is being repaired.
	 * @param plugin the plugin
	 * @throws PluginException
	 */
	void repair(AbstractPlugin plugin) throws PluginException;
	
	/**
	 * Triggered whenever the plugin is being uninstalled.
	 * @param plugin the plugin
	 * @throws PluginException
	 */
	void uninstall(AbstractPlugin plugin) throws PluginException;
}
