/*
 * Decompiled with CFR 0.152.
 */
package com.github.vatbub.commandlineUserPromptProcessor.parsables;

import com.github.vatbub.commandlineUserPromptProcessor.parsables.Parsable;
import com.github.vatbub.commandlineUserPromptProcessor.parsables.ParseException;
import org.jetbrains.annotations.Nullable;

public class ParsableDouble
implements Parsable<Double> {
    private double minValue;
    private double maxValue;
    private double value;
    @Nullable
    private Double defaultValue;

    public ParsableDouble() {
        this(null);
    }

    public ParsableDouble(Double defaultValue) {
        this(defaultValue, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public ParsableDouble(Double defaultValue, double minValue, double maxValue) {
        this.setDefaultValue(defaultValue);
        this.setAcceptedValues(minValue, maxValue);
    }

    public void setAcceptedValues(double minValue, double maxValue) {
        if (maxValue < minValue) {
            throw new IllegalArgumentException("maxValue must be bigger than or equal to minValue");
        }
        this.maxValue = maxValue;
        this.minValue = minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getMinValue() {
        return this.minValue;
    }

    @Override
    public void fromString(String s) throws ParseException {
        try {
            this.value = Double.parseDouble(s);
            if (this.value < this.minValue || this.value > this.maxValue) {
                throw new IndexOutOfBoundsException();
            }
        }
        catch (NumberFormatException e) {
            if (this.defaultValue != null) {
                this.value = this.defaultValue;
            }
            throw new ParseException();
        }
    }

    @Override
    @Nullable
    public String getOptionsString() {
        if (this.minValue == Double.NEGATIVE_INFINITY && this.maxValue == Double.POSITIVE_INFINITY) {
            return null;
        }
        if (this.minValue != Double.NEGATIVE_INFINITY && this.maxValue != Double.POSITIVE_INFINITY) {
            return this.minValue + " <= x <= " + this.maxValue;
        }
        if (this.minValue != Double.NEGATIVE_INFINITY) {
            return this.minValue + " <= x";
        }
        return "x <= " + this.maxValue;
    }

    @Override
    @Nullable
    public String getStringForDefaultValue() {
        if (this.defaultValue == null) {
            return null;
        }
        return this.defaultValue.toString();
    }

    @Override
    @Nullable
    public Double getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(@Nullable Double defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public Double toValue() {
        return this.value;
    }
}

