/*
 * Decompiled with CFR 0.152.
 */
package com.github.vatbub.javaautostart;

import com.github.vatbub.javaautostart.AutoStartLaunchConfig;
import com.github.vatbub.javaautostart.AutoStartManager;
import com.github.vatbub.javaautostart.Interpreter;
import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B3\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J5\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0007H\u00d6\u0001R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000b\u00a8\u0006 "}, d2={"Lcom/github/vatbub/javaautostart/AutoStartLaunchConfig;", "", "jarFileLocation", "Ljava/io/File;", "interpreter", "Lcom/github/vatbub/javaautostart/Interpreter;", "jvmOptions", "", "additionalArgs", "(Ljava/io/File;Lcom/github/vatbub/javaautostart/Interpreter;Ljava/lang/String;Ljava/lang/String;)V", "getAdditionalArgs", "()Ljava/lang/String;", "asCommand", "getAsCommand", "asCommand$delegate", "Lkotlin/Lazy;", "getInterpreter", "()Lcom/github/vatbub/javaautostart/Interpreter;", "getJarFileLocation", "()Ljava/io/File;", "getJvmOptions", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "javaAutoStart"})
public final class AutoStartLaunchConfig {
    @NotNull
    private final File jarFileLocation;
    @NotNull
    private final Interpreter interpreter;
    @Nullable
    private final String jvmOptions;
    @Nullable
    private final String additionalArgs;
    @NotNull
    private final Lazy asCommand$delegate;

    @JvmOverloads
    public AutoStartLaunchConfig(@NotNull File jarFileLocation, @NotNull Interpreter interpreter, @Nullable String jvmOptions, @Nullable String additionalArgs) {
        Intrinsics.checkNotNullParameter((Object)jarFileLocation, (String)"jarFileLocation");
        Intrinsics.checkNotNullParameter((Object)((Object)interpreter), (String)"interpreter");
        this.jarFileLocation = jarFileLocation;
        this.interpreter = interpreter;
        this.jvmOptions = jvmOptions;
        this.additionalArgs = additionalArgs;
        this.asCommand$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ AutoStartLaunchConfig this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                File jreBin = new File(System.getProperty("java.home"), "bin");
                Interpreter interpreter = this.this$0.getInterpreter();
                int n = asCommand.WhenMappings.$EnumSwitchMapping$0[interpreter.ordinal()];
                File interpreterLocation = switch (n) {
                    case 1 -> jreBin.toPath().resolve("java.exe").toFile();
                    case 2 -> jreBin.toPath().resolve("javaw.exe").toFile();
                    default -> throw new NoWhenBranchMatchedException();
                };
                StringBuilder commandBuilder = new StringBuilder("" + '\"' + interpreterLocation + '\"');
                if (this.this$0.getJvmOptions() != null) {
                    commandBuilder.append(Intrinsics.stringPlus((String)" ", (Object)this.this$0.getJvmOptions()));
                }
                commandBuilder.append(" -jar ").append("" + '\"' + this.this$0.getJarFileLocation() + '\"');
                if (this.this$0.getAdditionalArgs() != null) {
                    commandBuilder.append(Intrinsics.stringPlus((String)" ", (Object)this.this$0.getAdditionalArgs()));
                }
                String string = commandBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"commandBuilder.toString()");
                return string;
            }
        }));
    }

    public /* synthetic */ AutoStartLaunchConfig(File file, Interpreter interpreter, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            file = new File(AutoStartManager.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        if ((n & 2) != 0) {
            interpreter = Interpreter.javaw;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        this(file, interpreter, string, string2);
    }

    @NotNull
    public final File getJarFileLocation() {
        return this.jarFileLocation;
    }

    @NotNull
    public final Interpreter getInterpreter() {
        return this.interpreter;
    }

    @Nullable
    public final String getJvmOptions() {
        return this.jvmOptions;
    }

    @Nullable
    public final String getAdditionalArgs() {
        return this.additionalArgs;
    }

    @NotNull
    public final String getAsCommand() {
        Lazy lazy = this.asCommand$delegate;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    @NotNull
    public final File component1() {
        return this.jarFileLocation;
    }

    @NotNull
    public final Interpreter component2() {
        return this.interpreter;
    }

    @Nullable
    public final String component3() {
        return this.jvmOptions;
    }

    @Nullable
    public final String component4() {
        return this.additionalArgs;
    }

    @NotNull
    public final AutoStartLaunchConfig copy(@NotNull File jarFileLocation, @NotNull Interpreter interpreter, @Nullable String jvmOptions, @Nullable String additionalArgs) {
        Intrinsics.checkNotNullParameter((Object)jarFileLocation, (String)"jarFileLocation");
        Intrinsics.checkNotNullParameter((Object)((Object)interpreter), (String)"interpreter");
        return new AutoStartLaunchConfig(jarFileLocation, interpreter, jvmOptions, additionalArgs);
    }

    public static /* synthetic */ AutoStartLaunchConfig copy$default(AutoStartLaunchConfig autoStartLaunchConfig, File file, Interpreter interpreter, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            file = autoStartLaunchConfig.jarFileLocation;
        }
        if ((n & 2) != 0) {
            interpreter = autoStartLaunchConfig.interpreter;
        }
        if ((n & 4) != 0) {
            string = autoStartLaunchConfig.jvmOptions;
        }
        if ((n & 8) != 0) {
            string2 = autoStartLaunchConfig.additionalArgs;
        }
        return autoStartLaunchConfig.copy(file, interpreter, string, string2);
    }

    @NotNull
    public String toString() {
        return "AutoStartLaunchConfig(jarFileLocation=" + this.jarFileLocation + ", interpreter=" + (Object)((Object)this.interpreter) + ", jvmOptions=" + this.jvmOptions + ", additionalArgs=" + this.additionalArgs + ')';
    }

    public int hashCode() {
        int result = this.jarFileLocation.hashCode();
        result = result * 31 + this.interpreter.hashCode();
        result = result * 31 + (this.jvmOptions == null ? 0 : this.jvmOptions.hashCode());
        result = result * 31 + (this.additionalArgs == null ? 0 : this.additionalArgs.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AutoStartLaunchConfig)) {
            return false;
        }
        AutoStartLaunchConfig autoStartLaunchConfig = (AutoStartLaunchConfig)other;
        if (!Intrinsics.areEqual((Object)this.jarFileLocation, (Object)autoStartLaunchConfig.jarFileLocation)) {
            return false;
        }
        if (this.interpreter != autoStartLaunchConfig.interpreter) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.jvmOptions, (Object)autoStartLaunchConfig.jvmOptions)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.additionalArgs, (Object)autoStartLaunchConfig.additionalArgs);
    }

    @JvmOverloads
    public AutoStartLaunchConfig(@NotNull File jarFileLocation, @NotNull Interpreter interpreter, @Nullable String jvmOptions) {
        Intrinsics.checkNotNullParameter((Object)jarFileLocation, (String)"jarFileLocation");
        Intrinsics.checkNotNullParameter((Object)((Object)interpreter), (String)"interpreter");
        this(jarFileLocation, interpreter, jvmOptions, null, 8, null);
    }

    @JvmOverloads
    public AutoStartLaunchConfig(@NotNull File jarFileLocation, @NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)jarFileLocation, (String)"jarFileLocation");
        Intrinsics.checkNotNullParameter((Object)((Object)interpreter), (String)"interpreter");
        this(jarFileLocation, interpreter, null, null, 12, null);
    }

    @JvmOverloads
    public AutoStartLaunchConfig(@NotNull File jarFileLocation) {
        Intrinsics.checkNotNullParameter((Object)jarFileLocation, (String)"jarFileLocation");
        this(jarFileLocation, null, null, null, 14, null);
    }

    @JvmOverloads
    public AutoStartLaunchConfig() {
        this(null, null, null, null, 15, null);
    }
}

