/*
 * Decompiled with CFR 0.152.
 */
package com.github.venth.failsafe.rxjava2.completableobservation;

import com.github.venth.failsafe.rxjava2.completableobservation.ObservationDisposed;
import com.github.venth.failsafe.rxjava2.completableobservation.ObservationState;
import io.reactivex.CompletableObserver;
import io.reactivex.disposables.Disposable;
import net.jodah.failsafe.CircuitBreaker;

class ObservationActivated
implements ObservationState {
    private final Disposable disposable;
    private final CompletableObserver observer;
    private final CircuitBreaker circuitBreaker;

    ObservationActivated(Disposable disposable, CompletableObserver observer, CircuitBreaker circuitBreaker) {
        this.disposable = disposable;
        this.observer = observer;
        this.circuitBreaker = circuitBreaker;
    }

    @Override
    public ObservationState activate(Disposable disposable) {
        return this;
    }

    @Override
    public void onError(Throwable e) {
        this.circuitBreaker.recordFailure(e);
        this.observer.onError(e);
    }

    @Override
    public ObservationState dispose() {
        this.disposable.dispose();
        return new ObservationDisposed();
    }

    @Override
    public boolean isDisposed() {
        return false;
    }

    @Override
    public void onComplete() {
        this.circuitBreaker.recordSuccess();
        this.observer.onComplete();
    }
}

